<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleHistory StructType
 * @subpackage Structs
 */
class VehicleHistory extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVehicleEvent
     */
    public $Events;
    /**
     * Constructor method for VehicleHistory
     * @uses VehicleHistory::setName()
     * @uses VehicleHistory::setEvents()
     * @param string $name
     * @param \ArrayType\ArrayOfVehicleEvent $events
     */
    public function __construct($name = null, \ArrayType\ArrayOfVehicleEvent $events = null)
    {
        $this
            ->setName($name)
            ->setEvents($events);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\VehicleHistory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Events value
     * @return \ArrayType\ArrayOfVehicleEvent|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * Set Events value
     * @param \ArrayType\ArrayOfVehicleEvent $events
     * @return \StructType\VehicleHistory
     */
    public function setEvents(\ArrayType\ArrayOfVehicleEvent $events = null)
    {
        $this->Events = $events;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
