<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEvent StructType
 * @subpackage Structs
 */
class VehicleEvent extends AbstractStructBase
{
    /**
     * The EventDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EventDateTime;
    /**
     * The PositionDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PositionDateTime;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Road;
    /**
     * The Town
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EventType
     */
    public $Type;
    /**
     * The AdditionalEventInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAdditionalInformation
     */
    public $AdditionalEventInfo;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * Constructor method for VehicleEvent
     * @uses VehicleEvent::setEventDateTime()
     * @uses VehicleEvent::setPositionDateTime()
     * @uses VehicleEvent::setLatitude()
     * @uses VehicleEvent::setLongitude()
     * @uses VehicleEvent::setRoad()
     * @uses VehicleEvent::setTown()
     * @uses VehicleEvent::setPostcode()
     * @uses VehicleEvent::setType()
     * @uses VehicleEvent::setAdditionalEventInfo()
     * @uses VehicleEvent::setCountry()
     * @param string $eventDateTime
     * @param string $positionDateTime
     * @param float $latitude
     * @param float $longitude
     * @param string $road
     * @param string $town
     * @param string $postcode
     * @param \StructType\EventType $type
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalEventInfo
     * @param string $country
     */
    public function __construct($eventDateTime = null, $positionDateTime = null, $latitude = null, $longitude = null, $road = null, $town = null, $postcode = null, \StructType\EventType $type = null, \ArrayType\ArrayOfAdditionalInformation $additionalEventInfo = null, $country = null)
    {
        $this
            ->setEventDateTime($eventDateTime)
            ->setPositionDateTime($positionDateTime)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setRoad($road)
            ->setTown($town)
            ->setPostcode($postcode)
            ->setType($type)
            ->setAdditionalEventInfo($additionalEventInfo)
            ->setCountry($country);
    }
    /**
     * Get EventDateTime value
     * @return string
     */
    public function getEventDateTime()
    {
        return $this->EventDateTime;
    }
    /**
     * Set EventDateTime value
     * @param string $eventDateTime
     * @return \StructType\VehicleEvent
     */
    public function setEventDateTime($eventDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTime) && !is_string($eventDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDateTime)), __LINE__);
        }
        $this->EventDateTime = $eventDateTime;
        return $this;
    }
    /**
     * Get PositionDateTime value
     * @return string
     */
    public function getPositionDateTime()
    {
        return $this->PositionDateTime;
    }
    /**
     * Set PositionDateTime value
     * @param string $positionDateTime
     * @return \StructType\VehicleEvent
     */
    public function setPositionDateTime($positionDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($positionDateTime) && !is_string($positionDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($positionDateTime)), __LINE__);
        }
        $this->PositionDateTime = $positionDateTime;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\VehicleEvent
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\VehicleEvent
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->Road;
    }
    /**
     * Set Road value
     * @param string $road
     * @return \StructType\VehicleEvent
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->Road = $road;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \StructType\VehicleEvent
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\VehicleEvent
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\EventType|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\EventType $type
     * @return \StructType\VehicleEvent
     */
    public function setType(\StructType\EventType $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AdditionalEventInfo value
     * @return \ArrayType\ArrayOfAdditionalInformation|null
     */
    public function getAdditionalEventInfo()
    {
        return $this->AdditionalEventInfo;
    }
    /**
     * Set AdditionalEventInfo value
     * @param \ArrayType\ArrayOfAdditionalInformation $additionalEventInfo
     * @return \StructType\VehicleEvent
     */
    public function setAdditionalEventInfo(\ArrayType\ArrayOfAdditionalInformation $additionalEventInfo = null)
    {
        $this->AdditionalEventInfo = $additionalEventInfo;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\VehicleEvent
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
