<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCheckDetail StructType
 * @subpackage Structs
 */
class VehicleCheckDetail extends OpenElementElement
{
    /**
     * The DisplayOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DisplayOrder;
    /**
     * The CheckLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckLabel;
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Result;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The LabelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelCode;
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The CheckStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckStatus;
    /**
     * Constructor method for VehicleCheckDetail
     * @uses VehicleCheckDetail::setDisplayOrder()
     * @uses VehicleCheckDetail::setCheckLabel()
     * @uses VehicleCheckDetail::setResult()
     * @uses VehicleCheckDetail::setReason()
     * @uses VehicleCheckDetail::setLabelCode()
     * @uses VehicleCheckDetail::setStatusCode()
     * @uses VehicleCheckDetail::setCheckStatus()
     * @param int $displayOrder
     * @param string $checkLabel
     * @param string $result
     * @param string $reason
     * @param string $labelCode
     * @param string $statusCode
     * @param string $checkStatus
     */
    public function __construct($displayOrder = null, $checkLabel = null, $result = null, $reason = null, $labelCode = null, $statusCode = null, $checkStatus = null)
    {
        $this
            ->setDisplayOrder($displayOrder)
            ->setCheckLabel($checkLabel)
            ->setResult($result)
            ->setReason($reason)
            ->setLabelCode($labelCode)
            ->setStatusCode($statusCode)
            ->setCheckStatus($checkStatus);
    }
    /**
     * Get DisplayOrder value
     * @return int
     */
    public function getDisplayOrder()
    {
        return $this->DisplayOrder;
    }
    /**
     * Set DisplayOrder value
     * @param int $displayOrder
     * @return \StructType\VehicleCheckDetail
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrder) && !is_numeric($displayOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($displayOrder)), __LINE__);
        }
        $this->DisplayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get CheckLabel value
     * @return string|null
     */
    public function getCheckLabel()
    {
        return $this->CheckLabel;
    }
    /**
     * Set CheckLabel value
     * @param string $checkLabel
     * @return \StructType\VehicleCheckDetail
     */
    public function setCheckLabel($checkLabel = null)
    {
        // validation for constraint: string
        if (!is_null($checkLabel) && !is_string($checkLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkLabel)), __LINE__);
        }
        $this->CheckLabel = $checkLabel;
        return $this;
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\VehicleCheckDetail
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\VehicleCheckDetail
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get LabelCode value
     * @return string|null
     */
    public function getLabelCode()
    {
        return $this->LabelCode;
    }
    /**
     * Set LabelCode value
     * @param string $labelCode
     * @return \StructType\VehicleCheckDetail
     */
    public function setLabelCode($labelCode = null)
    {
        // validation for constraint: string
        if (!is_null($labelCode) && !is_string($labelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelCode)), __LINE__);
        }
        $this->LabelCode = $labelCode;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\VehicleCheckDetail
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get CheckStatus value
     * @return string|null
     */
    public function getCheckStatus()
    {
        return $this->CheckStatus;
    }
    /**
     * Set CheckStatus value
     * @param string $checkStatus
     * @return \StructType\VehicleCheckDetail
     */
    public function setCheckStatus($checkStatus = null)
    {
        // validation for constraint: string
        if (!is_null($checkStatus) && !is_string($checkStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkStatus)), __LINE__);
        }
        $this->CheckStatus = $checkStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleCheckDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
