<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCheck StructType
 * @subpackage Structs
 */
class VehicleCheck extends OpenElementElement
{
    /**
     * The CheckDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CheckDateTime;
    /**
     * The EndOfDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EndOfDay;
    /**
     * The DriverName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverName;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The PrintName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrintName;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVehicleCheckDetail
     */
    public $Details;
    /**
     * The VehicleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleName;
    /**
     * The SupervisorSignature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupervisorSignature;
    /**
     * Constructor method for VehicleCheck
     * @uses VehicleCheck::setCheckDateTime()
     * @uses VehicleCheck::setEndOfDay()
     * @uses VehicleCheck::setDriverName()
     * @uses VehicleCheck::setNotes()
     * @uses VehicleCheck::setPrintName()
     * @uses VehicleCheck::setSignature()
     * @uses VehicleCheck::setDetails()
     * @uses VehicleCheck::setVehicleName()
     * @uses VehicleCheck::setSupervisorSignature()
     * @param string $checkDateTime
     * @param bool $endOfDay
     * @param string $driverName
     * @param string $notes
     * @param string $printName
     * @param string $signature
     * @param \ArrayType\ArrayOfVehicleCheckDetail $details
     * @param string $vehicleName
     * @param string $supervisorSignature
     */
    public function __construct($checkDateTime = null, $endOfDay = null, $driverName = null, $notes = null, $printName = null, $signature = null, \ArrayType\ArrayOfVehicleCheckDetail $details = null, $vehicleName = null, $supervisorSignature = null)
    {
        $this
            ->setCheckDateTime($checkDateTime)
            ->setEndOfDay($endOfDay)
            ->setDriverName($driverName)
            ->setNotes($notes)
            ->setPrintName($printName)
            ->setSignature($signature)
            ->setDetails($details)
            ->setVehicleName($vehicleName)
            ->setSupervisorSignature($supervisorSignature);
    }
    /**
     * Get CheckDateTime value
     * @return string
     */
    public function getCheckDateTime()
    {
        return $this->CheckDateTime;
    }
    /**
     * Set CheckDateTime value
     * @param string $checkDateTime
     * @return \StructType\VehicleCheck
     */
    public function setCheckDateTime($checkDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkDateTime) && !is_string($checkDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkDateTime)), __LINE__);
        }
        $this->CheckDateTime = $checkDateTime;
        return $this;
    }
    /**
     * Get EndOfDay value
     * @return bool
     */
    public function getEndOfDay()
    {
        return $this->EndOfDay;
    }
    /**
     * Set EndOfDay value
     * @param bool $endOfDay
     * @return \StructType\VehicleCheck
     */
    public function setEndOfDay($endOfDay = null)
    {
        // validation for constraint: boolean
        if (!is_null($endOfDay) && !is_bool($endOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($endOfDay)), __LINE__);
        }
        $this->EndOfDay = $endOfDay;
        return $this;
    }
    /**
     * Get DriverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->DriverName;
    }
    /**
     * Set DriverName value
     * @param string $driverName
     * @return \StructType\VehicleCheck
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverName)), __LINE__);
        }
        $this->DriverName = $driverName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\VehicleCheck
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get PrintName value
     * @return string|null
     */
    public function getPrintName()
    {
        return $this->PrintName;
    }
    /**
     * Set PrintName value
     * @param string $printName
     * @return \StructType\VehicleCheck
     */
    public function setPrintName($printName = null)
    {
        // validation for constraint: string
        if (!is_null($printName) && !is_string($printName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($printName)), __LINE__);
        }
        $this->PrintName = $printName;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \StructType\VehicleCheck
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signature)), __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfVehicleCheckDetail|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfVehicleCheckDetail $details
     * @return \StructType\VehicleCheck
     */
    public function setDetails(\ArrayType\ArrayOfVehicleCheckDetail $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get VehicleName value
     * @return string|null
     */
    public function getVehicleName()
    {
        return $this->VehicleName;
    }
    /**
     * Set VehicleName value
     * @param string $vehicleName
     * @return \StructType\VehicleCheck
     */
    public function setVehicleName($vehicleName = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleName) && !is_string($vehicleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleName)), __LINE__);
        }
        $this->VehicleName = $vehicleName;
        return $this;
    }
    /**
     * Get SupervisorSignature value
     * @return string|null
     */
    public function getSupervisorSignature()
    {
        return $this->SupervisorSignature;
    }
    /**
     * Set SupervisorSignature value
     * @param string $supervisorSignature
     * @return \StructType\VehicleCheck
     */
    public function setSupervisorSignature($supervisorSignature = null)
    {
        // validation for constraint: string
        if (!is_null($supervisorSignature) && !is_string($supervisorSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supervisorSignature)), __LINE__);
        }
        $this->SupervisorSignature = $supervisorSignature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleCheck
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
