<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAtContact StructType
 * @subpackage Structs
 */
class VehicleAtContact extends OpenElementElement
{
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The StoppedAtDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StoppedAtDateTime;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The VehicleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleName;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationName;
    /**
     * The LocationReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationReference;
    /**
     * The Road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Road;
    /**
     * The Town
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * Constructor method for VehicleAtContact
     * @uses VehicleAtContact::setLongitude()
     * @uses VehicleAtContact::setLatitude()
     * @uses VehicleAtContact::setStoppedAtDateTime()
     * @uses VehicleAtContact::setCountry()
     * @uses VehicleAtContact::setVehicleName()
     * @uses VehicleAtContact::setLocationName()
     * @uses VehicleAtContact::setLocationReference()
     * @uses VehicleAtContact::setRoad()
     * @uses VehicleAtContact::setTown()
     * @uses VehicleAtContact::setPostcode()
     * @param float $longitude
     * @param float $latitude
     * @param string $stoppedAtDateTime
     * @param string $country
     * @param string $vehicleName
     * @param string $locationName
     * @param string $locationReference
     * @param string $road
     * @param string $town
     * @param string $postcode
     */
    public function __construct($longitude = null, $latitude = null, $stoppedAtDateTime = null, $country = null, $vehicleName = null, $locationName = null, $locationReference = null, $road = null, $town = null, $postcode = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setStoppedAtDateTime($stoppedAtDateTime)
            ->setCountry($country)
            ->setVehicleName($vehicleName)
            ->setLocationName($locationName)
            ->setLocationReference($locationReference)
            ->setRoad($road)
            ->setTown($town)
            ->setPostcode($postcode);
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\VehicleAtContact
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\VehicleAtContact
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get StoppedAtDateTime value
     * @return string
     */
    public function getStoppedAtDateTime()
    {
        return $this->StoppedAtDateTime;
    }
    /**
     * Set StoppedAtDateTime value
     * @param string $stoppedAtDateTime
     * @return \StructType\VehicleAtContact
     */
    public function setStoppedAtDateTime($stoppedAtDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($stoppedAtDateTime) && !is_string($stoppedAtDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stoppedAtDateTime)), __LINE__);
        }
        $this->StoppedAtDateTime = $stoppedAtDateTime;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\VehicleAtContact
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get VehicleName value
     * @return string|null
     */
    public function getVehicleName()
    {
        return $this->VehicleName;
    }
    /**
     * Set VehicleName value
     * @param string $vehicleName
     * @return \StructType\VehicleAtContact
     */
    public function setVehicleName($vehicleName = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleName) && !is_string($vehicleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleName)), __LINE__);
        }
        $this->VehicleName = $vehicleName;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \StructType\VehicleAtContact
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get LocationReference value
     * @return string|null
     */
    public function getLocationReference()
    {
        return $this->LocationReference;
    }
    /**
     * Set LocationReference value
     * @param string $locationReference
     * @return \StructType\VehicleAtContact
     */
    public function setLocationReference($locationReference = null)
    {
        // validation for constraint: string
        if (!is_null($locationReference) && !is_string($locationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationReference)), __LINE__);
        }
        $this->LocationReference = $locationReference;
        return $this;
    }
    /**
     * Get Road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->Road;
    }
    /**
     * Set Road value
     * @param string $road
     * @return \StructType\VehicleAtContact
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->Road = $road;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \StructType\VehicleAtContact
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\VehicleAtContact
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleAtContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
