<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vehicle StructType
 * @subpackage Structs
 */
class Vehicle extends AbstractStructBase
{
    /**
     * The distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $distance;
    /**
     * The currentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currentStatus;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The lastUpdated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastUpdated;
    /**
     * The speedKilometres
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $speedKilometres;
    /**
     * The directionDegrees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $directionDegrees;
    /**
     * The registration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $registration;
    /**
     * The road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $road;
    /**
     * The town
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $town;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * Constructor method for vehicle
     * @uses Vehicle::setDistance()
     * @uses Vehicle::setCurrentStatus()
     * @uses Vehicle::setLatitude()
     * @uses Vehicle::setLongitude()
     * @uses Vehicle::setLastUpdated()
     * @uses Vehicle::setSpeedKilometres()
     * @uses Vehicle::setDirectionDegrees()
     * @uses Vehicle::setRegistration()
     * @uses Vehicle::setRoad()
     * @uses Vehicle::setTown()
     * @uses Vehicle::setPostcode()
     * @uses Vehicle::setCountry()
     * @param float $distance
     * @param string $currentStatus
     * @param float $latitude
     * @param float $longitude
     * @param string $lastUpdated
     * @param int $speedKilometres
     * @param int $directionDegrees
     * @param string $registration
     * @param string $road
     * @param string $town
     * @param string $postcode
     * @param string $country
     */
    public function __construct($distance = null, $currentStatus = null, $latitude = null, $longitude = null, $lastUpdated = null, $speedKilometres = null, $directionDegrees = null, $registration = null, $road = null, $town = null, $postcode = null, $country = null)
    {
        $this
            ->setDistance($distance)
            ->setCurrentStatus($currentStatus)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setLastUpdated($lastUpdated)
            ->setSpeedKilometres($speedKilometres)
            ->setDirectionDegrees($directionDegrees)
            ->setRegistration($registration)
            ->setRoad($road)
            ->setTown($town)
            ->setPostcode($postcode)
            ->setCountry($country);
    }
    /**
     * Get distance value
     * @return float
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set distance value
     * @param float $distance
     * @return \StructType\Vehicle
     */
    public function setDistance($distance = null)
    {
        $this->distance = $distance;
        return $this;
    }
    /**
     * Get currentStatus value
     * @return string
     */
    public function getCurrentStatus()
    {
        return $this->currentStatus;
    }
    /**
     * Set currentStatus value
     * @uses \EnumType\StatusOption::valueIsValid()
     * @uses \EnumType\StatusOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentStatus
     * @return \StructType\Vehicle
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusOption::valueIsValid($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $currentStatus, implode(', ', \EnumType\StatusOption::getValidValues())), __LINE__);
        }
        $this->currentStatus = $currentStatus;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\Vehicle
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\Vehicle
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get lastUpdated value
     * @return string
     */
    public function getLastUpdated()
    {
        return $this->lastUpdated;
    }
    /**
     * Set lastUpdated value
     * @param string $lastUpdated
     * @return \StructType\Vehicle
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->lastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get speedKilometres value
     * @return int
     */
    public function getSpeedKilometres()
    {
        return $this->speedKilometres;
    }
    /**
     * Set speedKilometres value
     * @param int $speedKilometres
     * @return \StructType\Vehicle
     */
    public function setSpeedKilometres($speedKilometres = null)
    {
        // validation for constraint: int
        if (!is_null($speedKilometres) && !is_numeric($speedKilometres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speedKilometres)), __LINE__);
        }
        $this->speedKilometres = $speedKilometres;
        return $this;
    }
    /**
     * Get directionDegrees value
     * @return int
     */
    public function getDirectionDegrees()
    {
        return $this->directionDegrees;
    }
    /**
     * Set directionDegrees value
     * @param int $directionDegrees
     * @return \StructType\Vehicle
     */
    public function setDirectionDegrees($directionDegrees = null)
    {
        // validation for constraint: int
        if (!is_null($directionDegrees) && !is_numeric($directionDegrees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($directionDegrees)), __LINE__);
        }
        $this->directionDegrees = $directionDegrees;
        return $this;
    }
    /**
     * Get registration value
     * @return string|null
     */
    public function getRegistration()
    {
        return $this->registration;
    }
    /**
     * Set registration value
     * @param string $registration
     * @return \StructType\Vehicle
     */
    public function setRegistration($registration = null)
    {
        // validation for constraint: string
        if (!is_null($registration) && !is_string($registration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registration)), __LINE__);
        }
        $this->registration = $registration;
        return $this;
    }
    /**
     * Get road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->road;
    }
    /**
     * Set road value
     * @param string $road
     * @return \StructType\Vehicle
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->road = $road;
        return $this;
    }
    /**
     * Get town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->town;
    }
    /**
     * Set town value
     * @param string $town
     * @return \StructType\Vehicle
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->town = $town;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Vehicle
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Vehicle
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
