<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemperatureAlert StructType
 * @subpackage Structs
 */
class TemperatureAlert extends WebServiceAlert
{
    /**
     * The MinTemp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MinTemp;
    /**
     * The MaxTemp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaxTemp;
    /**
     * The compartment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $compartment;
    /**
     * The RollingMins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RollingMins;
    /**
     * The RepeatMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepeatMinutes;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $End;
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Start;
    /**
     * The ExcludeContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExcludeContact;
    /**
     * The ExcludeContactGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExcludeContactGroup;
    /**
     * Constructor method for TemperatureAlert
     * @uses TemperatureAlert::setMinTemp()
     * @uses TemperatureAlert::setMaxTemp()
     * @uses TemperatureAlert::setCompartment()
     * @uses TemperatureAlert::setRollingMins()
     * @uses TemperatureAlert::setRepeatMinutes()
     * @uses TemperatureAlert::setEnd()
     * @uses TemperatureAlert::setStart()
     * @uses TemperatureAlert::setExcludeContact()
     * @uses TemperatureAlert::setExcludeContactGroup()
     * @param int $minTemp
     * @param int $maxTemp
     * @param string $compartment
     * @param int $rollingMins
     * @param int $repeatMinutes
     * @param string $end
     * @param string $start
     * @param string $excludeContact
     * @param string $excludeContactGroup
     */
    public function __construct($minTemp = null, $maxTemp = null, $compartment = null, $rollingMins = null, $repeatMinutes = null, $end = null, $start = null, $excludeContact = null, $excludeContactGroup = null)
    {
        $this
            ->setMinTemp($minTemp)
            ->setMaxTemp($maxTemp)
            ->setCompartment($compartment)
            ->setRollingMins($rollingMins)
            ->setRepeatMinutes($repeatMinutes)
            ->setEnd($end)
            ->setStart($start)
            ->setExcludeContact($excludeContact)
            ->setExcludeContactGroup($excludeContactGroup);
    }
    /**
     * Get MinTemp value
     * @return int
     */
    public function getMinTemp()
    {
        return $this->MinTemp;
    }
    /**
     * Set MinTemp value
     * @param int $minTemp
     * @return \StructType\TemperatureAlert
     */
    public function setMinTemp($minTemp = null)
    {
        // validation for constraint: int
        if (!is_null($minTemp) && !is_numeric($minTemp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minTemp)), __LINE__);
        }
        $this->MinTemp = $minTemp;
        return $this;
    }
    /**
     * Get MaxTemp value
     * @return int
     */
    public function getMaxTemp()
    {
        return $this->MaxTemp;
    }
    /**
     * Set MaxTemp value
     * @param int $maxTemp
     * @return \StructType\TemperatureAlert
     */
    public function setMaxTemp($maxTemp = null)
    {
        // validation for constraint: int
        if (!is_null($maxTemp) && !is_numeric($maxTemp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxTemp)), __LINE__);
        }
        $this->MaxTemp = $maxTemp;
        return $this;
    }
    /**
     * Get compartment value
     * @return string
     */
    public function getCompartment()
    {
        return $this->compartment;
    }
    /**
     * Set compartment value
     * @uses \EnumType\Compartment::valueIsValid()
     * @uses \EnumType\Compartment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $compartment
     * @return \StructType\TemperatureAlert
     */
    public function setCompartment($compartment = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Compartment::valueIsValid($compartment)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $compartment, implode(', ', \EnumType\Compartment::getValidValues())), __LINE__);
        }
        $this->compartment = $compartment;
        return $this;
    }
    /**
     * Get RollingMins value
     * @return int
     */
    public function getRollingMins()
    {
        return $this->RollingMins;
    }
    /**
     * Set RollingMins value
     * @param int $rollingMins
     * @return \StructType\TemperatureAlert
     */
    public function setRollingMins($rollingMins = null)
    {
        // validation for constraint: int
        if (!is_null($rollingMins) && !is_numeric($rollingMins)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rollingMins)), __LINE__);
        }
        $this->RollingMins = $rollingMins;
        return $this;
    }
    /**
     * Get RepeatMinutes value
     * @return int
     */
    public function getRepeatMinutes()
    {
        return $this->RepeatMinutes;
    }
    /**
     * Set RepeatMinutes value
     * @param int $repeatMinutes
     * @return \StructType\TemperatureAlert
     */
    public function setRepeatMinutes($repeatMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($repeatMinutes) && !is_numeric($repeatMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($repeatMinutes)), __LINE__);
        }
        $this->RepeatMinutes = $repeatMinutes;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\TemperatureAlert
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\TemperatureAlert
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get ExcludeContact value
     * @return string|null
     */
    public function getExcludeContact()
    {
        return $this->ExcludeContact;
    }
    /**
     * Set ExcludeContact value
     * @param string $excludeContact
     * @return \StructType\TemperatureAlert
     */
    public function setExcludeContact($excludeContact = null)
    {
        // validation for constraint: string
        if (!is_null($excludeContact) && !is_string($excludeContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($excludeContact)), __LINE__);
        }
        $this->ExcludeContact = $excludeContact;
        return $this;
    }
    /**
     * Get ExcludeContactGroup value
     * @return string|null
     */
    public function getExcludeContactGroup()
    {
        return $this->ExcludeContactGroup;
    }
    /**
     * Set ExcludeContactGroup value
     * @param string $excludeContactGroup
     * @return \StructType\TemperatureAlert
     */
    public function setExcludeContactGroup($excludeContactGroup = null)
    {
        // validation for constraint: string
        if (!is_null($excludeContactGroup) && !is_string($excludeContactGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($excludeContactGroup)), __LINE__);
        }
        $this->ExcludeContactGroup = $excludeContactGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TemperatureAlert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
