<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopEtaAlert StructType
 * @subpackage Structs
 */
class StopEtaAlert extends WebServiceStopAlert
{
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Radius;
    /**
     * The RadiusUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RadiusUnit;
    /**
     * The TypeOfVehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeOfVehicle;
    /**
     * Constructor method for StopEtaAlert
     * @uses StopEtaAlert::setRadius()
     * @uses StopEtaAlert::setRadiusUnit()
     * @uses StopEtaAlert::setTypeOfVehicle()
     * @param float $radius
     * @param string $radiusUnit
     * @param string $typeOfVehicle
     */
    public function __construct($radius = null, $radiusUnit = null, $typeOfVehicle = null)
    {
        $this
            ->setRadius($radius)
            ->setRadiusUnit($radiusUnit)
            ->setTypeOfVehicle($typeOfVehicle);
    }
    /**
     * Get Radius value
     * @return float
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param float $radius
     * @return \StructType\StopEtaAlert
     */
    public function setRadius($radius = null)
    {
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get RadiusUnit value
     * @return string
     */
    public function getRadiusUnit()
    {
        return $this->RadiusUnit;
    }
    /**
     * Set RadiusUnit value
     * @uses \EnumType\DistanceUnit::valueIsValid()
     * @uses \EnumType\DistanceUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $radiusUnit
     * @return \StructType\StopEtaAlert
     */
    public function setRadiusUnit($radiusUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnit::valueIsValid($radiusUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $radiusUnit, implode(', ', \EnumType\DistanceUnit::getValidValues())), __LINE__);
        }
        $this->RadiusUnit = $radiusUnit;
        return $this;
    }
    /**
     * Get TypeOfVehicle value
     * @return string
     */
    public function getTypeOfVehicle()
    {
        return $this->TypeOfVehicle;
    }
    /**
     * Set TypeOfVehicle value
     * @uses \EnumType\VehicleType::valueIsValid()
     * @uses \EnumType\VehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfVehicle
     * @return \StructType\StopEtaAlert
     */
    public function setTypeOfVehicle($typeOfVehicle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleType::valueIsValid($typeOfVehicle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeOfVehicle, implode(', ', \EnumType\VehicleType::getValidValues())), __LINE__);
        }
        $this->TypeOfVehicle = $typeOfVehicle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopEtaAlert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
