<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetGroupForVehicles StructType
 * @subpackage Structs
 */
class SetGroupForVehicles extends AbstractStructBase
{
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The vehicleNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $vehicleNames;
    /**
     * The groupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $groupName;
    /**
     * Constructor method for SetGroupForVehicles
     * @uses SetGroupForVehicles::setLogin()
     * @uses SetGroupForVehicles::setPassword()
     * @uses SetGroupForVehicles::setVehicleNames()
     * @uses SetGroupForVehicles::setGroupName()
     * @param string $login
     * @param string $password
     * @param \ArrayType\ArrayOfString $vehicleNames
     * @param string $groupName
     */
    public function __construct($login = null, $password = null, \ArrayType\ArrayOfString $vehicleNames = null, $groupName = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setVehicleNames($vehicleNames)
            ->setGroupName($groupName);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\SetGroupForVehicles
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SetGroupForVehicles
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get vehicleNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getVehicleNames()
    {
        return $this->vehicleNames;
    }
    /**
     * Set vehicleNames value
     * @param \ArrayType\ArrayOfString $vehicleNames
     * @return \StructType\SetGroupForVehicles
     */
    public function setVehicleNames(\ArrayType\ArrayOfString $vehicleNames = null)
    {
        $this->vehicleNames = $vehicleNames;
        return $this;
    }
    /**
     * Get groupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->groupName;
    }
    /**
     * Set groupName value
     * @param string $groupName
     * @return \StructType\SetGroupForVehicles
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->groupName = $groupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetGroupForVehicles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
