<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenElementElement StructType
 * @subpackage Structs
 */
abstract class OpenElementElement extends AbstractStructBase
{
    /**
     * The AnyElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfXmlElement
     */
    public $AnyElements;
    /**
     * Constructor method for OpenElementElement
     * @uses OpenElementElement::setAnyElements()
     * @param \ArrayType\ArrayOfXmlElement $anyElements
     */
    public function __construct(\ArrayType\ArrayOfXmlElement $anyElements = null)
    {
        $this
            ->setAnyElements($anyElements);
    }
    /**
     * Get AnyElements value
     * @return \ArrayType\ArrayOfXmlElement|null
     */
    public function getAnyElements()
    {
        return $this->AnyElements;
    }
    /**
     * Set AnyElements value
     * @param \ArrayType\ArrayOfXmlElement $anyElements
     * @return \StructType\OpenElementElement
     */
    public function setAnyElements(\ArrayType\ArrayOfXmlElement $anyElements = null)
    {
        $this->AnyElements = $anyElements;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpenElementElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
