<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The sweepradius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sweepradius;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expiryDate;
    /**
     * The flaggedLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $flaggedLocation;
    /**
     * The group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $group;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The town
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $town;
    /**
     * The borough
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $borough;
    /**
     * The road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $road;
    /**
     * The roadnumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roadnumber;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * The information
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $information;
    /**
     * Constructor method for Location
     * @uses Location::setLongitude()
     * @uses Location::setLatitude()
     * @uses Location::setSweepradius()
     * @uses Location::setExpiryDate()
     * @uses Location::setFlaggedLocation()
     * @uses Location::setGroup()
     * @uses Location::setReference()
     * @uses Location::setName()
     * @uses Location::setCountry()
     * @uses Location::setTown()
     * @uses Location::setBorough()
     * @uses Location::setRoad()
     * @uses Location::setRoadnumber()
     * @uses Location::setPostcode()
     * @uses Location::setInformation()
     * @param float $longitude
     * @param float $latitude
     * @param int $sweepradius
     * @param string $expiryDate
     * @param bool $flaggedLocation
     * @param string $group
     * @param string $reference
     * @param string $name
     * @param string $country
     * @param string $town
     * @param string $borough
     * @param string $road
     * @param string $roadnumber
     * @param string $postcode
     * @param string $information
     */
    public function __construct($longitude = null, $latitude = null, $sweepradius = null, $expiryDate = null, $flaggedLocation = null, $group = null, $reference = null, $name = null, $country = null, $town = null, $borough = null, $road = null, $roadnumber = null, $postcode = null, $information = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setSweepradius($sweepradius)
            ->setExpiryDate($expiryDate)
            ->setFlaggedLocation($flaggedLocation)
            ->setGroup($group)
            ->setReference($reference)
            ->setName($name)
            ->setCountry($country)
            ->setTown($town)
            ->setBorough($borough)
            ->setRoad($road)
            ->setRoadnumber($roadnumber)
            ->setPostcode($postcode)
            ->setInformation($information);
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\Location
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\Location
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get sweepradius value
     * @return int
     */
    public function getSweepradius()
    {
        return $this->sweepradius;
    }
    /**
     * Set sweepradius value
     * @param int $sweepradius
     * @return \StructType\Location
     */
    public function setSweepradius($sweepradius = null)
    {
        // validation for constraint: int
        if (!is_null($sweepradius) && !is_numeric($sweepradius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sweepradius)), __LINE__);
        }
        $this->sweepradius = $sweepradius;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \StructType\Location
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get flaggedLocation value
     * @return bool
     */
    public function getFlaggedLocation()
    {
        return $this->flaggedLocation;
    }
    /**
     * Set flaggedLocation value
     * @param bool $flaggedLocation
     * @return \StructType\Location
     */
    public function setFlaggedLocation($flaggedLocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($flaggedLocation) && !is_bool($flaggedLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($flaggedLocation)), __LINE__);
        }
        $this->flaggedLocation = $flaggedLocation;
        return $this;
    }
    /**
     * Get group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param string $group
     * @return \StructType\Location
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        $this->group = $group;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\Location
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Location
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Location
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->town;
    }
    /**
     * Set town value
     * @param string $town
     * @return \StructType\Location
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        $this->town = $town;
        return $this;
    }
    /**
     * Get borough value
     * @return string|null
     */
    public function getBorough()
    {
        return $this->borough;
    }
    /**
     * Set borough value
     * @param string $borough
     * @return \StructType\Location
     */
    public function setBorough($borough = null)
    {
        // validation for constraint: string
        if (!is_null($borough) && !is_string($borough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($borough)), __LINE__);
        }
        $this->borough = $borough;
        return $this;
    }
    /**
     * Get road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->road;
    }
    /**
     * Set road value
     * @param string $road
     * @return \StructType\Location
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->road = $road;
        return $this;
    }
    /**
     * Get roadnumber value
     * @return string|null
     */
    public function getRoadnumber()
    {
        return $this->roadnumber;
    }
    /**
     * Set roadnumber value
     * @param string $roadnumber
     * @return \StructType\Location
     */
    public function setRoadnumber($roadnumber = null)
    {
        // validation for constraint: string
        if (!is_null($roadnumber) && !is_string($roadnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadnumber)), __LINE__);
        }
        $this->roadnumber = $roadnumber;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Location
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return \StructType\Location
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Location
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
