<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVehicleCalculatedCurrentOdometerReadings StructType
 * @subpackage Structs
 */
class GetVehicleCalculatedCurrentOdometerReadings extends AbstractStructBase
{
    /**
     * The vehicleCollectionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vehicleCollectionType;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $unit;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The vehicleNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $vehicleNames;
    /**
     * Constructor method for GetVehicleCalculatedCurrentOdometerReadings
     * @uses GetVehicleCalculatedCurrentOdometerReadings::setVehicleCollectionType()
     * @uses GetVehicleCalculatedCurrentOdometerReadings::setUnit()
     * @uses GetVehicleCalculatedCurrentOdometerReadings::setLogin()
     * @uses GetVehicleCalculatedCurrentOdometerReadings::setPassword()
     * @uses GetVehicleCalculatedCurrentOdometerReadings::setVehicleNames()
     * @param string $vehicleCollectionType
     * @param string $unit
     * @param string $login
     * @param string $password
     * @param \ArrayType\ArrayOfString $vehicleNames
     */
    public function __construct($vehicleCollectionType = null, $unit = null, $login = null, $password = null, \ArrayType\ArrayOfString $vehicleNames = null)
    {
        $this
            ->setVehicleCollectionType($vehicleCollectionType)
            ->setUnit($unit)
            ->setLogin($login)
            ->setPassword($password)
            ->setVehicleNames($vehicleNames);
    }
    /**
     * Get vehicleCollectionType value
     * @return string
     */
    public function getVehicleCollectionType()
    {
        return $this->vehicleCollectionType;
    }
    /**
     * Set vehicleCollectionType value
     * @uses \EnumType\VehicleCollectionType::valueIsValid()
     * @uses \EnumType\VehicleCollectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleCollectionType
     * @return \StructType\GetVehicleCalculatedCurrentOdometerReadings
     */
    public function setVehicleCollectionType($vehicleCollectionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleCollectionType::valueIsValid($vehicleCollectionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleCollectionType, implode(', ', \EnumType\VehicleCollectionType::getValidValues())), __LINE__);
        }
        $this->vehicleCollectionType = $vehicleCollectionType;
        return $this;
    }
    /**
     * Get unit value
     * @return string
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses \EnumType\DistanceUnit::valueIsValid()
     * @uses \EnumType\DistanceUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return \StructType\GetVehicleCalculatedCurrentOdometerReadings
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnit::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit, implode(', ', \EnumType\DistanceUnit::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetVehicleCalculatedCurrentOdometerReadings
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetVehicleCalculatedCurrentOdometerReadings
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get vehicleNames value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getVehicleNames()
    {
        return $this->vehicleNames;
    }
    /**
     * Set vehicleNames value
     * @param \ArrayType\ArrayOfString $vehicleNames
     * @return \StructType\GetVehicleCalculatedCurrentOdometerReadings
     */
    public function setVehicleNames(\ArrayType\ArrayOfString $vehicleNames = null)
    {
        $this->vehicleNames = $vehicleNames;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVehicleCalculatedCurrentOdometerReadings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
