<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getNearestVehicleV2 StructType
 * @subpackage Structs
 */
class GetNearestVehicleV2 extends AbstractStructBase
{
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The RoadDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RoadDistance;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postcode;
    /**
     * Constructor method for getNearestVehicleV2
     * @uses GetNearestVehicleV2::setLatitude()
     * @uses GetNearestVehicleV2::setLongitude()
     * @uses GetNearestVehicleV2::setRoadDistance()
     * @uses GetNearestVehicleV2::setLogin()
     * @uses GetNearestVehicleV2::setPassword()
     * @uses GetNearestVehicleV2::setPostcode()
     * @param float $latitude
     * @param float $longitude
     * @param bool $roadDistance
     * @param string $login
     * @param string $password
     * @param string $postcode
     */
    public function __construct($latitude = null, $longitude = null, $roadDistance = null, $login = null, $password = null, $postcode = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setRoadDistance($roadDistance)
            ->setLogin($login)
            ->setPassword($password)
            ->setPostcode($postcode);
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\GetNearestVehicleV2
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\GetNearestVehicleV2
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get RoadDistance value
     * @return bool
     */
    public function getRoadDistance()
    {
        return $this->RoadDistance;
    }
    /**
     * Set RoadDistance value
     * @param bool $roadDistance
     * @return \StructType\GetNearestVehicleV2
     */
    public function setRoadDistance($roadDistance = null)
    {
        // validation for constraint: boolean
        if (!is_null($roadDistance) && !is_bool($roadDistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($roadDistance)), __LINE__);
        }
        $this->RoadDistance = $roadDistance;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetNearestVehicleV2
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetNearestVehicleV2
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\GetNearestVehicleV2
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetNearestVehicleV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
