<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHistoryV2 StructType
 * @subpackage Structs
 */
class GetHistoryV2 extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The start
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $start;
    /**
     * The end
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $end;
    /**
     * The reverseGeocode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $reverseGeocode;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The names
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $names;
    /**
     * The eventsToReturn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEventType
     */
    public $eventsToReturn;
    /**
     * Constructor method for GetHistoryV2
     * @uses GetHistoryV2::setType()
     * @uses GetHistoryV2::setStart()
     * @uses GetHistoryV2::setEnd()
     * @uses GetHistoryV2::setReverseGeocode()
     * @uses GetHistoryV2::setLogin()
     * @uses GetHistoryV2::setPassword()
     * @uses GetHistoryV2::setNames()
     * @uses GetHistoryV2::setEventsToReturn()
     * @param string $type
     * @param string $start
     * @param string $end
     * @param bool $reverseGeocode
     * @param string $login
     * @param string $password
     * @param \ArrayType\ArrayOfString $names
     * @param \ArrayType\ArrayOfEventType $eventsToReturn
     */
    public function __construct($type = null, $start = null, $end = null, $reverseGeocode = null, $login = null, $password = null, \ArrayType\ArrayOfString $names = null, \ArrayType\ArrayOfEventType $eventsToReturn = null)
    {
        $this
            ->setType($type)
            ->setStart($start)
            ->setEnd($end)
            ->setReverseGeocode($reverseGeocode)
            ->setLogin($login)
            ->setPassword($password)
            ->setNames($names)
            ->setEventsToReturn($eventsToReturn);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\VehicleCollectionType::valueIsValid()
     * @uses \EnumType\VehicleCollectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GetHistoryV2
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleCollectionType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\VehicleCollectionType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get start value
     * @return string
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param string $start
     * @return \StructType\GetHistoryV2
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return string
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param string $end
     * @return \StructType\GetHistoryV2
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->end = $end;
        return $this;
    }
    /**
     * Get reverseGeocode value
     * @return bool
     */
    public function getReverseGeocode()
    {
        return $this->reverseGeocode;
    }
    /**
     * Set reverseGeocode value
     * @param bool $reverseGeocode
     * @return \StructType\GetHistoryV2
     */
    public function setReverseGeocode($reverseGeocode = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseGeocode) && !is_bool($reverseGeocode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reverseGeocode)), __LINE__);
        }
        $this->reverseGeocode = $reverseGeocode;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetHistoryV2
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetHistoryV2
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get names value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getNames()
    {
        return $this->names;
    }
    /**
     * Set names value
     * @param \ArrayType\ArrayOfString $names
     * @return \StructType\GetHistoryV2
     */
    public function setNames(\ArrayType\ArrayOfString $names = null)
    {
        $this->names = $names;
        return $this;
    }
    /**
     * Get eventsToReturn value
     * @return \ArrayType\ArrayOfEventType|null
     */
    public function getEventsToReturn()
    {
        return $this->eventsToReturn;
    }
    /**
     * Set eventsToReturn value
     * @param \ArrayType\ArrayOfEventType $eventsToReturn
     * @return \StructType\GetHistoryV2
     */
    public function setEventsToReturn(\ArrayType\ArrayOfEventType $eventsToReturn = null)
    {
        $this->eventsToReturn = $eventsToReturn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHistoryV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
