<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeliveryStatusChange StructType
 * @subpackage Structs
 */
class GetDeliveryStatusChange extends AbstractStructBase
{
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $endDate;
    /**
     * The searchData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $searchData;
    /**
     * The searchType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $searchType;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for GetDeliveryStatusChange
     * @uses GetDeliveryStatusChange::setStartDate()
     * @uses GetDeliveryStatusChange::setEndDate()
     * @uses GetDeliveryStatusChange::setSearchData()
     * @uses GetDeliveryStatusChange::setSearchType()
     * @uses GetDeliveryStatusChange::setLogin()
     * @uses GetDeliveryStatusChange::setPassword()
     * @param string $startDate
     * @param string $endDate
     * @param string $searchData
     * @param string $searchType
     * @param string $login
     * @param string $password
     */
    public function __construct($startDate = null, $endDate = null, $searchData = null, $searchType = null, $login = null, $password = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setSearchData($searchData)
            ->setSearchType($searchType)
            ->setLogin($login)
            ->setPassword($password);
    }
    /**
     * Get startDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetDeliveryStatusChange
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\GetDeliveryStatusChange
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get searchData value
     * @return string
     */
    public function getSearchData()
    {
        return $this->searchData;
    }
    /**
     * Set searchData value
     * @uses \EnumType\SearchData::valueIsValid()
     * @uses \EnumType\SearchData::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchData
     * @return \StructType\GetDeliveryStatusChange
     */
    public function setSearchData($searchData = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchData::valueIsValid($searchData)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchData, implode(', ', \EnumType\SearchData::getValidValues())), __LINE__);
        }
        $this->searchData = $searchData;
        return $this;
    }
    /**
     * Get searchType value
     * @return string
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\SearchType::valueIsValid()
     * @uses \EnumType\SearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\GetDeliveryStatusChange
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \EnumType\SearchType::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\GetDeliveryStatusChange
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetDeliveryStatusChange
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDeliveryStatusChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
