<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistanceForDriver StructType
 * @subpackage Structs
 */
class DistanceForDriver extends AbstractStructBase
{
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * The DriverName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverName;
    /**
     * The DriverKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverKey;
    /**
     * Constructor method for DistanceForDriver
     * @uses DistanceForDriver::setDistance()
     * @uses DistanceForDriver::setDriverName()
     * @uses DistanceForDriver::setDriverKey()
     * @param int $distance
     * @param string $driverName
     * @param string $driverKey
     */
    public function __construct($distance = null, $driverName = null, $driverKey = null)
    {
        $this
            ->setDistance($distance)
            ->setDriverName($driverName)
            ->setDriverKey($driverKey);
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\DistanceForDriver
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DriverName value
     * @return string|null
     */
    public function getDriverName()
    {
        return $this->DriverName;
    }
    /**
     * Set DriverName value
     * @param string $driverName
     * @return \StructType\DistanceForDriver
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverName)), __LINE__);
        }
        $this->DriverName = $driverName;
        return $this;
    }
    /**
     * Get DriverKey value
     * @return string|null
     */
    public function getDriverKey()
    {
        return $this->DriverKey;
    }
    /**
     * Set DriverKey value
     * @param string $driverKey
     * @return \StructType\DistanceForDriver
     */
    public function setDriverKey($driverKey = null)
    {
        // validation for constraint: string
        if (!is_null($driverKey) && !is_string($driverKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverKey)), __LINE__);
        }
        $this->DriverKey = $driverKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistanceForDriver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
