<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryStop StructType
 * @subpackage Structs
 */
class DeliveryStop extends OpenElementElement
{
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalTime;
    /**
     * The DepartureTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepartureTime;
    /**
     * The DurationMinutes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DurationMinutes;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The RouteReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RouteReference;
    /**
     * The LocationReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationReference;
    /**
     * The VehicleRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleRegistration;
    /**
     * The StopReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StopReference;
    /**
     * Constructor method for DeliveryStop
     * @uses DeliveryStop::setArrivalTime()
     * @uses DeliveryStop::setDepartureTime()
     * @uses DeliveryStop::setDurationMinutes()
     * @uses DeliveryStop::setLatitude()
     * @uses DeliveryStop::setLongitude()
     * @uses DeliveryStop::setRouteReference()
     * @uses DeliveryStop::setLocationReference()
     * @uses DeliveryStop::setVehicleRegistration()
     * @uses DeliveryStop::setStopReference()
     * @param string $arrivalTime
     * @param string $departureTime
     * @param float $durationMinutes
     * @param float $latitude
     * @param float $longitude
     * @param string $routeReference
     * @param string $locationReference
     * @param string $vehicleRegistration
     * @param string $stopReference
     */
    public function __construct($arrivalTime = null, $departureTime = null, $durationMinutes = null, $latitude = null, $longitude = null, $routeReference = null, $locationReference = null, $vehicleRegistration = null, $stopReference = null)
    {
        $this
            ->setArrivalTime($arrivalTime)
            ->setDepartureTime($departureTime)
            ->setDurationMinutes($durationMinutes)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setRouteReference($routeReference)
            ->setLocationReference($locationReference)
            ->setVehicleRegistration($vehicleRegistration)
            ->setStopReference($stopReference);
    }
    /**
     * Get ArrivalTime value
     * @return string
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\DeliveryStop
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\DeliveryStop
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureTime)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get DurationMinutes value
     * @return float
     */
    public function getDurationMinutes()
    {
        return $this->DurationMinutes;
    }
    /**
     * Set DurationMinutes value
     * @param float $durationMinutes
     * @return \StructType\DeliveryStop
     */
    public function setDurationMinutes($durationMinutes = null)
    {
        $this->DurationMinutes = $durationMinutes;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\DeliveryStop
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\DeliveryStop
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get RouteReference value
     * @return string|null
     */
    public function getRouteReference()
    {
        return $this->RouteReference;
    }
    /**
     * Set RouteReference value
     * @param string $routeReference
     * @return \StructType\DeliveryStop
     */
    public function setRouteReference($routeReference = null)
    {
        // validation for constraint: string
        if (!is_null($routeReference) && !is_string($routeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeReference)), __LINE__);
        }
        $this->RouteReference = $routeReference;
        return $this;
    }
    /**
     * Get LocationReference value
     * @return string|null
     */
    public function getLocationReference()
    {
        return $this->LocationReference;
    }
    /**
     * Set LocationReference value
     * @param string $locationReference
     * @return \StructType\DeliveryStop
     */
    public function setLocationReference($locationReference = null)
    {
        // validation for constraint: string
        if (!is_null($locationReference) && !is_string($locationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationReference)), __LINE__);
        }
        $this->LocationReference = $locationReference;
        return $this;
    }
    /**
     * Get VehicleRegistration value
     * @return string|null
     */
    public function getVehicleRegistration()
    {
        return $this->VehicleRegistration;
    }
    /**
     * Set VehicleRegistration value
     * @param string $vehicleRegistration
     * @return \StructType\DeliveryStop
     */
    public function setVehicleRegistration($vehicleRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleRegistration) && !is_string($vehicleRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleRegistration)), __LINE__);
        }
        $this->VehicleRegistration = $vehicleRegistration;
        return $this;
    }
    /**
     * Get StopReference value
     * @return string|null
     */
    public function getStopReference()
    {
        return $this->StopReference;
    }
    /**
     * Set StopReference value
     * @param string $stopReference
     * @return \StructType\DeliveryStop
     */
    public function setStopReference($stopReference = null)
    {
        // validation for constraint: string
        if (!is_null($stopReference) && !is_string($stopReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopReference)), __LINE__);
        }
        $this->StopReference = $stopReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryStop
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
