<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryLineItemUpdate StructType
 * @subpackage Structs
 */
class DeliveryLineItemUpdate extends AbstractStructBase
{
    /**
     * The ActualQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActualQuantity;
    /**
     * The LineReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineReference;
    /**
     * Constructor method for DeliveryLineItemUpdate
     * @uses DeliveryLineItemUpdate::setActualQuantity()
     * @uses DeliveryLineItemUpdate::setLineReference()
     * @param int $actualQuantity
     * @param string $lineReference
     */
    public function __construct($actualQuantity = null, $lineReference = null)
    {
        $this
            ->setActualQuantity($actualQuantity)
            ->setLineReference($lineReference);
    }
    /**
     * Get ActualQuantity value
     * @return int
     */
    public function getActualQuantity()
    {
        return $this->ActualQuantity;
    }
    /**
     * Set ActualQuantity value
     * @param int $actualQuantity
     * @return \StructType\DeliveryLineItemUpdate
     */
    public function setActualQuantity($actualQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($actualQuantity) && !is_numeric($actualQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($actualQuantity)), __LINE__);
        }
        $this->ActualQuantity = $actualQuantity;
        return $this;
    }
    /**
     * Get LineReference value
     * @return string|null
     */
    public function getLineReference()
    {
        return $this->LineReference;
    }
    /**
     * Set LineReference value
     * @param string $lineReference
     * @return \StructType\DeliveryLineItemUpdate
     */
    public function setLineReference($lineReference = null)
    {
        // validation for constraint: string
        if (!is_null($lineReference) && !is_string($lineReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineReference)), __LINE__);
        }
        $this->LineReference = $lineReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryLineItemUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
