<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delivery StructType
 * @subpackage Structs
 */
class Delivery extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalTime;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Duration;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Road
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Road;
    /**
     * The PostCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostCode;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The ContactPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPhone;
    /**
     * The ConsignmentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNumber;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The LocationReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationReference;
    /**
     * The LineItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLineItem
     */
    public $LineItems;
    /**
     * The CallAheadNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCallAheadNumber
     */
    public $CallAheadNumbers;
    /**
     * The EtaWindow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $EtaWindow;
    /**
     * Constructor method for Delivery
     * @uses Delivery::setLatitude()
     * @uses Delivery::setLongitude()
     * @uses Delivery::setArrivalTime()
     * @uses Delivery::setDuration()
     * @uses Delivery::setCompanyName()
     * @uses Delivery::setRoad()
     * @uses Delivery::setPostCode()
     * @uses Delivery::setCity()
     * @uses Delivery::setInfo()
     * @uses Delivery::setReference()
     * @uses Delivery::setContactName()
     * @uses Delivery::setContactPhone()
     * @uses Delivery::setConsignmentNumber()
     * @uses Delivery::setAccountNumber()
     * @uses Delivery::setLocationReference()
     * @uses Delivery::setLineItems()
     * @uses Delivery::setCallAheadNumbers()
     * @uses Delivery::setEtaWindow()
     * @param float $latitude
     * @param float $longitude
     * @param string $arrivalTime
     * @param float $duration
     * @param string $companyName
     * @param string $road
     * @param string $postCode
     * @param string $city
     * @param string $info
     * @param string $reference
     * @param string $contactName
     * @param string $contactPhone
     * @param string $consignmentNumber
     * @param string $accountNumber
     * @param string $locationReference
     * @param \ArrayType\ArrayOfLineItem $lineItems
     * @param \ArrayType\ArrayOfCallAheadNumber $callAheadNumbers
     * @param \StructType\DateRange $etaWindow
     */
    public function __construct($latitude = null, $longitude = null, $arrivalTime = null, $duration = null, $companyName = null, $road = null, $postCode = null, $city = null, $info = null, $reference = null, $contactName = null, $contactPhone = null, $consignmentNumber = null, $accountNumber = null, $locationReference = null, \ArrayType\ArrayOfLineItem $lineItems = null, \ArrayType\ArrayOfCallAheadNumber $callAheadNumbers = null, \StructType\DateRange $etaWindow = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setArrivalTime($arrivalTime)
            ->setDuration($duration)
            ->setCompanyName($companyName)
            ->setRoad($road)
            ->setPostCode($postCode)
            ->setCity($city)
            ->setInfo($info)
            ->setReference($reference)
            ->setContactName($contactName)
            ->setContactPhone($contactPhone)
            ->setConsignmentNumber($consignmentNumber)
            ->setAccountNumber($accountNumber)
            ->setLocationReference($locationReference)
            ->setLineItems($lineItems)
            ->setCallAheadNumbers($callAheadNumbers)
            ->setEtaWindow($etaWindow);
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\Delivery
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\Delivery
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\Delivery
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get Duration value
     * @return float
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param float $duration
     * @return \StructType\Delivery
     */
    public function setDuration($duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\Delivery
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Road value
     * @return string|null
     */
    public function getRoad()
    {
        return $this->Road;
    }
    /**
     * Set Road value
     * @param string $road
     * @return \StructType\Delivery
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        $this->Road = $road;
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \StructType\Delivery
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Delivery
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\Delivery
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\Delivery
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\Delivery
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get ContactPhone value
     * @return string|null
     */
    public function getContactPhone()
    {
        return $this->ContactPhone;
    }
    /**
     * Set ContactPhone value
     * @param string $contactPhone
     * @return \StructType\Delivery
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactPhone)), __LINE__);
        }
        $this->ContactPhone = $contactPhone;
        return $this;
    }
    /**
     * Get ConsignmentNumber value
     * @return string|null
     */
    public function getConsignmentNumber()
    {
        return $this->ConsignmentNumber;
    }
    /**
     * Set ConsignmentNumber value
     * @param string $consignmentNumber
     * @return \StructType\Delivery
     */
    public function setConsignmentNumber($consignmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNumber) && !is_string($consignmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consignmentNumber)), __LINE__);
        }
        $this->ConsignmentNumber = $consignmentNumber;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\Delivery
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get LocationReference value
     * @return string|null
     */
    public function getLocationReference()
    {
        return $this->LocationReference;
    }
    /**
     * Set LocationReference value
     * @param string $locationReference
     * @return \StructType\Delivery
     */
    public function setLocationReference($locationReference = null)
    {
        // validation for constraint: string
        if (!is_null($locationReference) && !is_string($locationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationReference)), __LINE__);
        }
        $this->LocationReference = $locationReference;
        return $this;
    }
    /**
     * Get LineItems value
     * @return \ArrayType\ArrayOfLineItem|null
     */
    public function getLineItems()
    {
        return $this->LineItems;
    }
    /**
     * Set LineItems value
     * @param \ArrayType\ArrayOfLineItem $lineItems
     * @return \StructType\Delivery
     */
    public function setLineItems(\ArrayType\ArrayOfLineItem $lineItems = null)
    {
        $this->LineItems = $lineItems;
        return $this;
    }
    /**
     * Get CallAheadNumbers value
     * @return \ArrayType\ArrayOfCallAheadNumber|null
     */
    public function getCallAheadNumbers()
    {
        return $this->CallAheadNumbers;
    }
    /**
     * Set CallAheadNumbers value
     * @param \ArrayType\ArrayOfCallAheadNumber $callAheadNumbers
     * @return \StructType\Delivery
     */
    public function setCallAheadNumbers(\ArrayType\ArrayOfCallAheadNumber $callAheadNumbers = null)
    {
        $this->CallAheadNumbers = $callAheadNumbers;
        return $this;
    }
    /**
     * Get EtaWindow value
     * @return \StructType\DateRange|null
     */
    public function getEtaWindow()
    {
        return $this->EtaWindow;
    }
    /**
     * Set EtaWindow value
     * @param \StructType\DateRange $etaWindow
     * @return \StructType\Delivery
     */
    public function setEtaWindow(\StructType\DateRange $etaWindow = null)
    {
        $this->EtaWindow = $etaWindow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
