<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateDeliveryResult StructType
 * @subpackage Structs
 */
class CreateDeliveryResult extends AbstractStructBase
{
    /**
     * The ResultFlags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResultFlags;
    /**
     * Constructor method for CreateDeliveryResult
     * @uses CreateDeliveryResult::setResultFlags()
     * @param string $resultFlags
     */
    public function __construct($resultFlags = null)
    {
        $this
            ->setResultFlags($resultFlags);
    }
    /**
     * Get ResultFlags value
     * @return string
     */
    public function getResultFlags()
    {
        return $this->ResultFlags;
    }
    /**
     * Set ResultFlags value
     * @uses \EnumType\DeliveryResultFlags::valueIsValid()
     * @uses \EnumType\DeliveryResultFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultFlags
     * @return \StructType\CreateDeliveryResult
     */
    public function setResultFlags($resultFlags = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryResultFlags::valueIsValid($resultFlags)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resultFlags, implode(', ', \EnumType\DeliveryResultFlags::getValidValues())), __LINE__);
        }
        $this->ResultFlags = $resultFlags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateDeliveryResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
