<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLocation $parameters
     * @return \StructType\AddLocationResponse|bool
     */
    public function addLocation(\StructType\AddLocation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addLocation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLocationV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLocationV2 $parameters
     * @return \StructType\AddLocationV2Response|bool
     */
    public function addLocationV2(\StructType\AddLocationV2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->addLocationV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddVehicleActualOdometerReadings
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVehicleActualOdometerReadings $parameters
     * @return \StructType\AddVehicleActualOdometerReadingsResponse|bool
     */
    public function AddVehicleActualOdometerReadings(\StructType\AddVehicleActualOdometerReadings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddVehicleActualOdometerReadings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddLocationResponse|\StructType\AddLocationV2Response|\StructType\AddVehicleActualOdometerReadingsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
