<?php

namespace EnumType;

/**
 * This class stands for DistanceUnit EnumType
 * @subpackage Enumerations
 */
class DistanceUnit
{
    /**
     * Constant for value 'Mile'
     * @return string 'Mile'
     */
    const VALUE_MILE = 'Mile';
    /**
     * Constant for value 'Kilometer'
     * @return string 'Kilometer'
     */
    const VALUE_KILOMETER = 'Kilometer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MILE
     * @uses self::VALUE_KILOMETER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MILE,
            self::VALUE_KILOMETER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
