<?php

namespace EnumType;

/**
 * This class stands for DeliveryResultFlags EnumType
 * @subpackage Enumerations
 */
class DeliveryResultFlags
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'GeocodeLookupFailure'
     * @return string 'GeocodeLookupFailure'
     */
    const VALUE_GEOCODE_LOOKUP_FAILURE = 'GeocodeLookupFailure';
    /**
     * Constant for value 'LocationLookupFailure'
     * @return string 'LocationLookupFailure'
     */
    const VALUE_LOCATION_LOOKUP_FAILURE = 'LocationLookupFailure';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_GEOCODE_LOOKUP_FAILURE
     * @uses self::VALUE_LOCATION_LOOKUP_FAILURE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_GEOCODE_LOOKUP_FAILURE,
            self::VALUE_LOCATION_LOOKUP_FAILURE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
