<?php

namespace EnumType;

/**
 * This class stands for ContactCollectionType EnumType
 * @subpackage Enumerations
 */
class ContactCollectionType
{
    /**
     * Constant for value 'Contacts'
     * @return string 'Contacts'
     */
    const VALUE_CONTACTS = 'Contacts';
    /**
     * Constant for value 'Groups'
     * @return string 'Groups'
     */
    const VALUE_GROUPS = 'Groups';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTACTS
     * @uses self::VALUE_GROUPS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTACTS,
            self::VALUE_GROUPS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
