<?php

namespace EnumType;

/**
 * This class stands for AllocatedDriverType EnumType
 * @subpackage Enumerations
 */
class AllocatedDriverType
{
    /**
     * Constant for value 'Name'
     * @return string 'Name'
     */
    const VALUE_NAME = 'Name';
    /**
     * Constant for value 'Reference'
     * @return string 'Reference'
     */
    const VALUE_REFERENCE = 'Reference';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NAME
     * @uses self::VALUE_REFERENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NAME,
            self::VALUE_REFERENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
