<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleHistory ArrayType
 * @subpackage Arrays
 */
class ArrayOfVehicleHistory extends AbstractStructArrayBase
{
    /**
     * The VehicleHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleHistory[]
     */
    public $VehicleHistory;
    /**
     * Constructor method for ArrayOfVehicleHistory
     * @uses ArrayOfVehicleHistory::setVehicleHistory()
     * @param \StructType\VehicleHistory[] $vehicleHistory
     */
    public function __construct(array $vehicleHistory = array())
    {
        $this
            ->setVehicleHistory($vehicleHistory);
    }
    /**
     * Get VehicleHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleHistory[]|null
     */
    public function getVehicleHistory()
    {
        return isset($this->VehicleHistory) ? $this->VehicleHistory : null;
    }
    /**
     * Set VehicleHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleHistory[] $vehicleHistory
     * @return \ArrayType\ArrayOfVehicleHistory
     */
    public function setVehicleHistory(array $vehicleHistory = array())
    {
        foreach ($vehicleHistory as $arrayOfVehicleHistoryVehicleHistoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleHistoryVehicleHistoryItem instanceof \StructType\VehicleHistory) {
                throw new \InvalidArgumentException(sprintf('The VehicleHistory property can only contain items of \StructType\VehicleHistory, "%s" given', is_object($arrayOfVehicleHistoryVehicleHistoryItem) ? get_class($arrayOfVehicleHistoryVehicleHistoryItem) : gettype($arrayOfVehicleHistoryVehicleHistoryItem)), __LINE__);
            }
        }
        if (is_null($vehicleHistory) || (is_array($vehicleHistory) && empty($vehicleHistory))) {
            unset($this->VehicleHistory);
        } else {
            $this->VehicleHistory = $vehicleHistory;
        }
        return $this;
    }
    /**
     * Add item to VehicleHistory value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleHistory $item
     * @return \ArrayType\ArrayOfVehicleHistory
     */
    public function addToVehicleHistory(\StructType\VehicleHistory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleHistory) {
            throw new \InvalidArgumentException(sprintf('The VehicleHistory property can only contain items of \StructType\VehicleHistory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleHistory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleHistory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleHistory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleHistory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleHistory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleHistory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleHistory
     */
    public function getAttributeName()
    {
        return 'VehicleHistory';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
