<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleCheckDetail ArrayType
 * @subpackage Arrays
 */
class ArrayOfVehicleCheckDetail extends AbstractStructArrayBase
{
    /**
     * The VehicleCheckDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleCheckDetail[]
     */
    public $VehicleCheckDetail;
    /**
     * Constructor method for ArrayOfVehicleCheckDetail
     * @uses ArrayOfVehicleCheckDetail::setVehicleCheckDetail()
     * @param \StructType\VehicleCheckDetail[] $vehicleCheckDetail
     */
    public function __construct(array $vehicleCheckDetail = array())
    {
        $this
            ->setVehicleCheckDetail($vehicleCheckDetail);
    }
    /**
     * Get VehicleCheckDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleCheckDetail[]|null
     */
    public function getVehicleCheckDetail()
    {
        return isset($this->VehicleCheckDetail) ? $this->VehicleCheckDetail : null;
    }
    /**
     * Set VehicleCheckDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleCheckDetail[] $vehicleCheckDetail
     * @return \ArrayType\ArrayOfVehicleCheckDetail
     */
    public function setVehicleCheckDetail(array $vehicleCheckDetail = array())
    {
        foreach ($vehicleCheckDetail as $arrayOfVehicleCheckDetailVehicleCheckDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleCheckDetailVehicleCheckDetailItem instanceof \StructType\VehicleCheckDetail) {
                throw new \InvalidArgumentException(sprintf('The VehicleCheckDetail property can only contain items of \StructType\VehicleCheckDetail, "%s" given', is_object($arrayOfVehicleCheckDetailVehicleCheckDetailItem) ? get_class($arrayOfVehicleCheckDetailVehicleCheckDetailItem) : gettype($arrayOfVehicleCheckDetailVehicleCheckDetailItem)), __LINE__);
            }
        }
        if (is_null($vehicleCheckDetail) || (is_array($vehicleCheckDetail) && empty($vehicleCheckDetail))) {
            unset($this->VehicleCheckDetail);
        } else {
            $this->VehicleCheckDetail = $vehicleCheckDetail;
        }
        return $this;
    }
    /**
     * Add item to VehicleCheckDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleCheckDetail $item
     * @return \ArrayType\ArrayOfVehicleCheckDetail
     */
    public function addToVehicleCheckDetail(\StructType\VehicleCheckDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleCheckDetail) {
            throw new \InvalidArgumentException(sprintf('The VehicleCheckDetail property can only contain items of \StructType\VehicleCheckDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleCheckDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleCheckDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleCheckDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleCheckDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleCheckDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleCheckDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleCheckDetail
     */
    public function getAttributeName()
    {
        return 'VehicleCheckDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleCheckDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
