<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStatusOptions ArrayType
 * @subpackage Arrays
 */
class ArrayOfStatusOptions extends AbstractStructArrayBase
{
    /**
     * The statusOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $statusOptions;
    /**
     * Constructor method for ArrayOfStatusOptions
     * @uses ArrayOfStatusOptions::setStatusOptions()
     * @param string[] $statusOptions
     */
    public function __construct(array $statusOptions = array())
    {
        $this
            ->setStatusOptions($statusOptions);
    }
    /**
     * Get statusOptions value
     * @return string[]|null
     */
    public function getStatusOptions()
    {
        return $this->statusOptions;
    }
    /**
     * Set statusOptions value
     * @uses \EnumType\StatusOptions::valueIsValid()
     * @uses \EnumType\StatusOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statusOptions
     * @return \ArrayType\ArrayOfStatusOptions
     */
    public function setStatusOptions(array $statusOptions = array())
    {
        $invalidValues = array();
        foreach ($statusOptions as $arrayOfStatusOptionsStatusOptionsItem) {
            if (!\EnumType\StatusOptions::valueIsValid($arrayOfStatusOptionsStatusOptionsItem)) {
                $invalidValues[] = var_export($arrayOfStatusOptionsStatusOptionsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\StatusOptions::getValidValues())), __LINE__);
        }
        $this->statusOptions = $statusOptions;
        return $this;
    }
    /**
     * Add item to statusOptions value
     * @uses \EnumType\StatusOptions::valueIsValid()
     * @uses \EnumType\StatusOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfStatusOptions
     */
    public function addToStatusOptions($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusOptions::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\StatusOptions::getValidValues())), __LINE__);
        }
        $this->statusOptions[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\StatusOptions::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfStatusOptions
     */
    public function add($item)
    {
        if (!\EnumType\StatusOptions::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\StatusOptions::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string statusOptions
     */
    public function getAttributeName()
    {
        return 'statusOptions';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStatusOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
