<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNextServiceInformation ArrayType
 * @subpackage Arrays
 */
class ArrayOfNextServiceInformation extends AbstractStructArrayBase
{
    /**
     * The NextServiceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NextServiceInformation[]
     */
    public $NextServiceInformation;
    /**
     * Constructor method for ArrayOfNextServiceInformation
     * @uses ArrayOfNextServiceInformation::setNextServiceInformation()
     * @param \StructType\NextServiceInformation[] $nextServiceInformation
     */
    public function __construct(array $nextServiceInformation = array())
    {
        $this
            ->setNextServiceInformation($nextServiceInformation);
    }
    /**
     * Get NextServiceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NextServiceInformation[]|null
     */
    public function getNextServiceInformation()
    {
        return isset($this->NextServiceInformation) ? $this->NextServiceInformation : null;
    }
    /**
     * Set NextServiceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NextServiceInformation[] $nextServiceInformation
     * @return \ArrayType\ArrayOfNextServiceInformation
     */
    public function setNextServiceInformation(array $nextServiceInformation = array())
    {
        foreach ($nextServiceInformation as $arrayOfNextServiceInformationNextServiceInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfNextServiceInformationNextServiceInformationItem instanceof \StructType\NextServiceInformation) {
                throw new \InvalidArgumentException(sprintf('The NextServiceInformation property can only contain items of \StructType\NextServiceInformation, "%s" given', is_object($arrayOfNextServiceInformationNextServiceInformationItem) ? get_class($arrayOfNextServiceInformationNextServiceInformationItem) : gettype($arrayOfNextServiceInformationNextServiceInformationItem)), __LINE__);
            }
        }
        if (is_null($nextServiceInformation) || (is_array($nextServiceInformation) && empty($nextServiceInformation))) {
            unset($this->NextServiceInformation);
        } else {
            $this->NextServiceInformation = $nextServiceInformation;
        }
        return $this;
    }
    /**
     * Add item to NextServiceInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\NextServiceInformation $item
     * @return \ArrayType\ArrayOfNextServiceInformation
     */
    public function addToNextServiceInformation(\StructType\NextServiceInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NextServiceInformation) {
            throw new \InvalidArgumentException(sprintf('The NextServiceInformation property can only contain items of \StructType\NextServiceInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NextServiceInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NextServiceInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NextServiceInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NextServiceInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NextServiceInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NextServiceInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NextServiceInformation
     */
    public function getAttributeName()
    {
        return 'NextServiceInformation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNextServiceInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
