<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfLineItem extends AbstractStructArrayBase
{
    /**
     * The LineItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LineItem[]
     */
    public $LineItem;
    /**
     * Constructor method for ArrayOfLineItem
     * @uses ArrayOfLineItem::setLineItem()
     * @param \StructType\LineItem[] $lineItem
     */
    public function __construct(array $lineItem = array())
    {
        $this
            ->setLineItem($lineItem);
    }
    /**
     * Get LineItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LineItem[]|null
     */
    public function getLineItem()
    {
        return isset($this->LineItem) ? $this->LineItem : null;
    }
    /**
     * Set LineItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem[] $lineItem
     * @return \ArrayType\ArrayOfLineItem
     */
    public function setLineItem(array $lineItem = array())
    {
        foreach ($lineItem as $arrayOfLineItemLineItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfLineItemLineItemItem instanceof \StructType\LineItem) {
                throw new \InvalidArgumentException(sprintf('The LineItem property can only contain items of \StructType\LineItem, "%s" given', is_object($arrayOfLineItemLineItemItem) ? get_class($arrayOfLineItemLineItemItem) : gettype($arrayOfLineItemLineItemItem)), __LINE__);
            }
        }
        if (is_null($lineItem) || (is_array($lineItem) && empty($lineItem))) {
            unset($this->LineItem);
        } else {
            $this->LineItem = $lineItem;
        }
        return $this;
    }
    /**
     * Add item to LineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem $item
     * @return \ArrayType\ArrayOfLineItem
     */
    public function addToLineItem(\StructType\LineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineItem) {
            throw new \InvalidArgumentException(sprintf('The LineItem property can only contain items of \StructType\LineItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LineItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LineItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LineItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LineItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LineItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LineItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineItem
     */
    public function getAttributeName()
    {
        return 'LineItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLineItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
