<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobV2 extends AbstractStructArrayBase
{
    /**
     * The JobV2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobV2[]
     */
    public $JobV2;
    /**
     * Constructor method for ArrayOfJobV2
     * @uses ArrayOfJobV2::setJobV2()
     * @param \StructType\JobV2[] $jobV2
     */
    public function __construct(array $jobV2 = array())
    {
        $this
            ->setJobV2($jobV2);
    }
    /**
     * Get JobV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobV2[]|null
     */
    public function getJobV2()
    {
        return isset($this->JobV2) ? $this->JobV2 : null;
    }
    /**
     * Set JobV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobV2[] $jobV2
     * @return \ArrayType\ArrayOfJobV2
     */
    public function setJobV2(array $jobV2 = array())
    {
        foreach ($jobV2 as $arrayOfJobV2JobV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfJobV2JobV2Item instanceof \StructType\JobV2) {
                throw new \InvalidArgumentException(sprintf('The JobV2 property can only contain items of \StructType\JobV2, "%s" given', is_object($arrayOfJobV2JobV2Item) ? get_class($arrayOfJobV2JobV2Item) : gettype($arrayOfJobV2JobV2Item)), __LINE__);
            }
        }
        if (is_null($jobV2) || (is_array($jobV2) && empty($jobV2))) {
            unset($this->JobV2);
        } else {
            $this->JobV2 = $jobV2;
        }
        return $this;
    }
    /**
     * Add item to JobV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\JobV2 $item
     * @return \ArrayType\ArrayOfJobV2
     */
    public function addToJobV2(\StructType\JobV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobV2) {
            throw new \InvalidArgumentException(sprintf('The JobV2 property can only contain items of \StructType\JobV2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JobV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobV2
     */
    public function getAttributeName()
    {
        return 'JobV2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJobV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
