<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDriver ArrayType
 * @subpackage Arrays
 */
class ArrayOfDriver extends AbstractStructArrayBase
{
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Driver[]
     */
    public $driver;
    /**
     * Constructor method for ArrayOfDriver
     * @uses ArrayOfDriver::setDriver()
     * @param \StructType\Driver[] $driver
     */
    public function __construct(array $driver = array())
    {
        $this
            ->setDriver($driver);
    }
    /**
     * Get driver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Driver[]|null
     */
    public function getDriver()
    {
        return isset($this->driver) ? $this->driver : null;
    }
    /**
     * Set driver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Driver[] $driver
     * @return \ArrayType\ArrayOfDriver
     */
    public function setDriver(array $driver = array())
    {
        foreach ($driver as $arrayOfDriverDriverItem) {
            // validation for constraint: itemType
            if (!$arrayOfDriverDriverItem instanceof \StructType\Driver) {
                throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \StructType\Driver, "%s" given', is_object($arrayOfDriverDriverItem) ? get_class($arrayOfDriverDriverItem) : gettype($arrayOfDriverDriverItem)), __LINE__);
            }
        }
        if (is_null($driver) || (is_array($driver) && empty($driver))) {
            unset($this->driver);
        } else {
            $this->driver = $driver;
        }
        return $this;
    }
    /**
     * Add item to driver value
     * @throws \InvalidArgumentException
     * @param \StructType\Driver $item
     * @return \ArrayType\ArrayOfDriver
     */
    public function addToDriver(\StructType\Driver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Driver) {
            throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \StructType\Driver, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driver[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Driver|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Driver|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Driver|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Driver|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Driver|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string driver
     */
    public function getAttributeName()
    {
        return 'driver';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDriver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
