<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdditionalInformation ArrayType
 * @subpackage Arrays
 */
class ArrayOfAdditionalInformation extends AbstractStructArrayBase
{
    /**
     * The AdditionalInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalInformation[]
     */
    public $AdditionalInformation;
    /**
     * Constructor method for ArrayOfAdditionalInformation
     * @uses ArrayOfAdditionalInformation::setAdditionalInformation()
     * @param \StructType\AdditionalInformation[] $additionalInformation
     */
    public function __construct(array $additionalInformation = array())
    {
        $this
            ->setAdditionalInformation($additionalInformation);
    }
    /**
     * Get AdditionalInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalInformation[]|null
     */
    public function getAdditionalInformation()
    {
        return isset($this->AdditionalInformation) ? $this->AdditionalInformation : null;
    }
    /**
     * Set AdditionalInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInformation[] $additionalInformation
     * @return \ArrayType\ArrayOfAdditionalInformation
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        foreach ($additionalInformation as $arrayOfAdditionalInformationAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdditionalInformationAdditionalInformationItem instanceof \StructType\AdditionalInformation) {
                throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of \StructType\AdditionalInformation, "%s" given', is_object($arrayOfAdditionalInformationAdditionalInformationItem) ? get_class($arrayOfAdditionalInformationAdditionalInformationItem) : gettype($arrayOfAdditionalInformationAdditionalInformationItem)), __LINE__);
            }
        }
        if (is_null($additionalInformation) || (is_array($additionalInformation) && empty($additionalInformation))) {
            unset($this->AdditionalInformation);
        } else {
            $this->AdditionalInformation = $additionalInformation;
        }
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInformation $item
     * @return \ArrayType\ArrayOfAdditionalInformation
     */
    public function addToAdditionalInformation(\StructType\AdditionalInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalInformation) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of \StructType\AdditionalInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AdditionalInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AdditionalInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AdditionalInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AdditionalInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AdditionalInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalInformation
     */
    public function getAttributeName()
    {
        return 'AdditionalInformation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAdditionalInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
