<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TestResponse StructType
 * @subpackage Structs
 */
class TestResponse extends AbstractStructBase
{
    /**
     * The TestResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestResult;
    /**
     * Constructor method for TestResponse
     * @uses TestResponse::setTestResult()
     * @param string $testResult
     */
    public function __construct($testResult = null)
    {
        $this
            ->setTestResult($testResult);
    }
    /**
     * Get TestResult value
     * @return string|null
     */
    public function getTestResult()
    {
        return $this->TestResult;
    }
    /**
     * Set TestResult value
     * @param string $testResult
     * @return \StructType\TestResponse
     */
    public function setTestResult($testResult = null)
    {
        // validation for constraint: string
        if (!is_null($testResult) && !is_string($testResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($testResult)), __LINE__);
        }
        $this->TestResult = $testResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
