<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSessionAvailability StructType
 * @subpackage Structs
 */
class GetSessionAvailability extends AbstractStructBase
{
    /**
     * The AtDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AtDate;
    /**
     * The Session
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Session;
    /**
     * The Covers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Covers;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The Prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prefix;
    /**
     * Constructor method for GetSessionAvailability
     * @uses GetSessionAvailability::setAtDate()
     * @uses GetSessionAvailability::setSession()
     * @uses GetSessionAvailability::setCovers()
     * @uses GetSessionAvailability::setProductID()
     * @uses GetSessionAvailability::setPrefix()
     * @param string $atDate
     * @param int $session
     * @param int $covers
     * @param int $productID
     * @param string $prefix
     */
    public function __construct($atDate = null, $session = null, $covers = null, $productID = null, $prefix = null)
    {
        $this
            ->setAtDate($atDate)
            ->setSession($session)
            ->setCovers($covers)
            ->setProductID($productID)
            ->setPrefix($prefix);
    }
    /**
     * Get AtDate value
     * @return string
     */
    public function getAtDate()
    {
        return $this->AtDate;
    }
    /**
     * Set AtDate value
     * @param string $atDate
     * @return \StructType\GetSessionAvailability
     */
    public function setAtDate($atDate = null)
    {
        // validation for constraint: string
        if (!is_null($atDate) && !is_string($atDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($atDate)), __LINE__);
        }
        $this->AtDate = $atDate;
        return $this;
    }
    /**
     * Get Session value
     * @return int
     */
    public function getSession()
    {
        return $this->Session;
    }
    /**
     * Set Session value
     * @param int $session
     * @return \StructType\GetSessionAvailability
     */
    public function setSession($session = null)
    {
        // validation for constraint: int
        if (!is_null($session) && !is_numeric($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($session)), __LINE__);
        }
        $this->Session = $session;
        return $this;
    }
    /**
     * Get Covers value
     * @return int
     */
    public function getCovers()
    {
        return $this->Covers;
    }
    /**
     * Set Covers value
     * @param int $covers
     * @return \StructType\GetSessionAvailability
     */
    public function setCovers($covers = null)
    {
        // validation for constraint: int
        if (!is_null($covers) && !is_numeric($covers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($covers)), __LINE__);
        }
        $this->Covers = $covers;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \StructType\GetSessionAvailability
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \StructType\GetSessionAvailability
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSessionAvailability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
