<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdvancedBookingLimitV4 StructType
 * @subpackage Structs
 */
class GetAdvancedBookingLimitV4 extends AbstractStructBase
{
    /**
     * The SuggestedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SuggestedDate;
    /**
     * The RestaurantGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RestaurantGroup;
    /**
     * The Prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prefix;
    /**
     * Constructor method for GetAdvancedBookingLimitV4
     * @uses GetAdvancedBookingLimitV4::setSuggestedDate()
     * @uses GetAdvancedBookingLimitV4::setRestaurantGroup()
     * @uses GetAdvancedBookingLimitV4::setPrefix()
     * @param string $suggestedDate
     * @param string $restaurantGroup
     * @param string $prefix
     */
    public function __construct($suggestedDate = null, $restaurantGroup = null, $prefix = null)
    {
        $this
            ->setSuggestedDate($suggestedDate)
            ->setRestaurantGroup($restaurantGroup)
            ->setPrefix($prefix);
    }
    /**
     * Get SuggestedDate value
     * @return string
     */
    public function getSuggestedDate()
    {
        return $this->SuggestedDate;
    }
    /**
     * Set SuggestedDate value
     * @param string $suggestedDate
     * @return \StructType\GetAdvancedBookingLimitV4
     */
    public function setSuggestedDate($suggestedDate = null)
    {
        // validation for constraint: string
        if (!is_null($suggestedDate) && !is_string($suggestedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($suggestedDate)), __LINE__);
        }
        $this->SuggestedDate = $suggestedDate;
        return $this;
    }
    /**
     * Get RestaurantGroup value
     * @return string|null
     */
    public function getRestaurantGroup()
    {
        return $this->RestaurantGroup;
    }
    /**
     * Set RestaurantGroup value
     * @param string $restaurantGroup
     * @return \StructType\GetAdvancedBookingLimitV4
     */
    public function setRestaurantGroup($restaurantGroup = null)
    {
        // validation for constraint: string
        if (!is_null($restaurantGroup) && !is_string($restaurantGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restaurantGroup)), __LINE__);
        }
        $this->RestaurantGroup = $restaurantGroup;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \StructType\GetAdvancedBookingLimitV4
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAdvancedBookingLimitV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
