<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Book ServiceType
 * @subpackage Services
 */
class Book extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BookTable
     * Meta informations extracted from the WSDL
     * - documentation: v4 and v5: Make a booking - use appropriate record version
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BookTable $parameters
     * @return \StructType\BookTableResponse|bool
     */
    public function BookTable(\StructType\BookTable $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BookTable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BookTableResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
