<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewsCollection StructType
 * @subpackage Structs
 */
class NewsCollection extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The NewsArticles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfNewsArticle
     */
    public $NewsArticles;
    /**
     * Constructor method for NewsCollection
     * @uses NewsCollection::setName()
     * @uses NewsCollection::setNewsArticles()
     * @param string $name
     * @param \ArrayType\ArrayOfNewsArticle $newsArticles
     */
    public function __construct($name = null, \ArrayType\ArrayOfNewsArticle $newsArticles = null)
    {
        $this
            ->setName($name)
            ->setNewsArticles($newsArticles);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\NewsCollection
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NewsArticles value
     * @return \ArrayType\ArrayOfNewsArticle|null
     */
    public function getNewsArticles()
    {
        return $this->NewsArticles;
    }
    /**
     * Set NewsArticles value
     * @param \ArrayType\ArrayOfNewsArticle $newsArticles
     * @return \StructType\NewsCollection
     */
    public function setNewsArticles(\ArrayType\ArrayOfNewsArticle $newsArticles = null)
    {
        $this->NewsArticles = $newsArticles;
        return $this;
    }
}
