<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageResult StructType
 * @subpackage Structs
 */
class ImageResult extends AbstractStructBase
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The MediaUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MediaUrl;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The DisplayUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayUrl;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * The FileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $FileSize;
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The Thumbnail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Thumbnail
     */
    public $Thumbnail;
    /**
     * Constructor method for ImageResult
     * @uses ImageResult::setTitle()
     * @uses ImageResult::setMediaUrl()
     * @uses ImageResult::setUrl()
     * @uses ImageResult::setDisplayUrl()
     * @uses ImageResult::setWidth()
     * @uses ImageResult::setHeight()
     * @uses ImageResult::setFileSize()
     * @uses ImageResult::setContentType()
     * @uses ImageResult::setThumbnail()
     * @param string $title
     * @param string $mediaUrl
     * @param string $url
     * @param string $displayUrl
     * @param int $width
     * @param int $height
     * @param int $fileSize
     * @param string $contentType
     * @param \StructType\Thumbnail $thumbnail
     */
    public function __construct($title = null, $mediaUrl = null, $url = null, $displayUrl = null, $width = null, $height = null, $fileSize = null, $contentType = null, \StructType\Thumbnail $thumbnail = null)
    {
        $this
            ->setTitle($title)
            ->setMediaUrl($mediaUrl)
            ->setUrl($url)
            ->setDisplayUrl($displayUrl)
            ->setWidth($width)
            ->setHeight($height)
            ->setFileSize($fileSize)
            ->setContentType($contentType)
            ->setThumbnail($thumbnail);
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\ImageResult
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get MediaUrl value
     * @return string|null
     */
    public function getMediaUrl()
    {
        return $this->MediaUrl;
    }
    /**
     * Set MediaUrl value
     * @param string $mediaUrl
     * @return \StructType\ImageResult
     */
    public function setMediaUrl($mediaUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mediaUrl) && !is_string($mediaUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaUrl, true), gettype($mediaUrl)), __LINE__);
        }
        $this->MediaUrl = $mediaUrl;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\ImageResult
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get DisplayUrl value
     * @return string|null
     */
    public function getDisplayUrl()
    {
        return $this->DisplayUrl;
    }
    /**
     * Set DisplayUrl value
     * @param string $displayUrl
     * @return \StructType\ImageResult
     */
    public function setDisplayUrl($displayUrl = null)
    {
        // validation for constraint: string
        if (!is_null($displayUrl) && !is_string($displayUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayUrl, true), gettype($displayUrl)), __LINE__);
        }
        $this->DisplayUrl = $displayUrl;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \StructType\ImageResult
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\ImageResult
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\ImageResult
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\ImageResult
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get Thumbnail value
     * @return \StructType\Thumbnail|null
     */
    public function getThumbnail()
    {
        return $this->Thumbnail;
    }
    /**
     * Set Thumbnail value
     * @param \StructType\Thumbnail $thumbnail
     * @return \StructType\ImageResult
     */
    public function setThumbnail(\StructType\Thumbnail $thumbnail = null)
    {
        $this->Thumbnail = $thumbnail;
        return $this;
    }
}
