<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSearchOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfSearchOption extends AbstractStructArrayBase
{
    /**
     * The SearchOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SearchOption;
    /**
     * Constructor method for ArrayOfSearchOption
     * @uses ArrayOfSearchOption::setSearchOption()
     * @param string[] $searchOption
     */
    public function __construct(array $searchOption = array())
    {
        $this
            ->setSearchOption($searchOption);
    }
    /**
     * Get SearchOption value
     * @return string[]|null
     */
    public function getSearchOption()
    {
        return $this->SearchOption;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchOptionForArrayConstraintsFromSetSearchOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSearchOptionSearchOptionItem) {
            // validation for constraint: enumeration
            if (!\EnumType\SearchOption::valueIsValid($arrayOfSearchOptionSearchOptionItem)) {
                $invalidValues[] = is_object($arrayOfSearchOptionSearchOptionItem) ? get_class($arrayOfSearchOptionSearchOptionItem) : sprintf('%s(%s)', gettype($arrayOfSearchOptionSearchOptionItem), var_export($arrayOfSearchOptionSearchOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchOption', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\SearchOption::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SearchOption value
     * @uses \EnumType\SearchOption::valueIsValid()
     * @uses \EnumType\SearchOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $searchOption
     * @return \ArrayType\ArrayOfSearchOption
     */
    public function setSearchOption(array $searchOption = array())
    {
        // validation for constraint: array
        if ('' !== ($searchOptionArrayErrorMessage = self::validateSearchOptionForArrayConstraintsFromSetSearchOption($searchOption))) {
            throw new \InvalidArgumentException($searchOptionArrayErrorMessage, __LINE__);
        }
        $this->SearchOption = $searchOption;
        return $this;
    }
    /**
     * Add item to SearchOption value
     * @uses \EnumType\SearchOption::valueIsValid()
     * @uses \EnumType\SearchOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfSearchOption
     */
    public function addToSearchOption($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchOption::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchOption', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SearchOption::getValidValues())), __LINE__);
        }
        $this->SearchOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\SearchOption::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfSearchOption
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchOption::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchOption', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SearchOption::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SearchOption
     */
    public function getAttributeName()
    {
        return 'SearchOption';
    }
}
