<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNewsArticle ArrayType
 * @subpackage Arrays
 */
class ArrayOfNewsArticle extends AbstractStructArrayBase
{
    /**
     * The NewsArticle
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NewsArticle[]
     */
    public $NewsArticle;
    /**
     * Constructor method for ArrayOfNewsArticle
     * @uses ArrayOfNewsArticle::setNewsArticle()
     * @param \StructType\NewsArticle[] $newsArticle
     */
    public function __construct(array $newsArticle = array())
    {
        $this
            ->setNewsArticle($newsArticle);
    }
    /**
     * Get NewsArticle value
     * @return \StructType\NewsArticle[]|null
     */
    public function getNewsArticle()
    {
        return $this->NewsArticle;
    }
    /**
     * This method is responsible for validating the values passed to the setNewsArticle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNewsArticle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNewsArticleForArrayConstraintsFromSetNewsArticle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNewsArticleNewsArticleItem) {
            // validation for constraint: itemType
            if (!$arrayOfNewsArticleNewsArticleItem instanceof \StructType\NewsArticle) {
                $invalidValues[] = is_object($arrayOfNewsArticleNewsArticleItem) ? get_class($arrayOfNewsArticleNewsArticleItem) : sprintf('%s(%s)', gettype($arrayOfNewsArticleNewsArticleItem), var_export($arrayOfNewsArticleNewsArticleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NewsArticle property can only contain items of type \StructType\NewsArticle, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NewsArticle value
     * @throws \InvalidArgumentException
     * @param \StructType\NewsArticle[] $newsArticle
     * @return \ArrayType\ArrayOfNewsArticle
     */
    public function setNewsArticle(array $newsArticle = array())
    {
        // validation for constraint: array
        if ('' !== ($newsArticleArrayErrorMessage = self::validateNewsArticleForArrayConstraintsFromSetNewsArticle($newsArticle))) {
            throw new \InvalidArgumentException($newsArticleArrayErrorMessage, __LINE__);
        }
        $this->NewsArticle = $newsArticle;
        return $this;
    }
    /**
     * Add item to NewsArticle value
     * @throws \InvalidArgumentException
     * @param \StructType\NewsArticle $item
     * @return \ArrayType\ArrayOfNewsArticle
     */
    public function addToNewsArticle(\StructType\NewsArticle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NewsArticle) {
            throw new \InvalidArgumentException(sprintf('The NewsArticle property can only contain items of type \StructType\NewsArticle, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NewsArticle[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NewsArticle|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NewsArticle|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NewsArticle|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NewsArticle|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NewsArticle|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NewsArticle
     */
    public function getAttributeName()
    {
        return 'NewsArticle';
    }
}
