<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebResult StructType
 * @subpackage Structs
 */
class WebResult extends AbstractStructBase
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The CacheUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CacheUrl;
    /**
     * The DisplayUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayUrl;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The SearchTags
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWebSearchTag
     */
    public $SearchTags;
    /**
     * The DeepLinks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDeepLink
     */
    public $DeepLinks;
    /**
     * Constructor method for WebResult
     * @uses WebResult::setTitle()
     * @uses WebResult::setDescription()
     * @uses WebResult::setUrl()
     * @uses WebResult::setCacheUrl()
     * @uses WebResult::setDisplayUrl()
     * @uses WebResult::setDateTime()
     * @uses WebResult::setSearchTags()
     * @uses WebResult::setDeepLinks()
     * @param string $title
     * @param string $description
     * @param string $url
     * @param string $cacheUrl
     * @param string $displayUrl
     * @param string $dateTime
     * @param \ArrayType\ArrayOfWebSearchTag $searchTags
     * @param \ArrayType\ArrayOfDeepLink $deepLinks
     */
    public function __construct($title = null, $description = null, $url = null, $cacheUrl = null, $displayUrl = null, $dateTime = null, \ArrayType\ArrayOfWebSearchTag $searchTags = null, \ArrayType\ArrayOfDeepLink $deepLinks = null)
    {
        $this
            ->setTitle($title)
            ->setDescription($description)
            ->setUrl($url)
            ->setCacheUrl($cacheUrl)
            ->setDisplayUrl($displayUrl)
            ->setDateTime($dateTime)
            ->setSearchTags($searchTags)
            ->setDeepLinks($deepLinks);
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\WebResult
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\WebResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\WebResult
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get CacheUrl value
     * @return string|null
     */
    public function getCacheUrl()
    {
        return $this->CacheUrl;
    }
    /**
     * Set CacheUrl value
     * @param string $cacheUrl
     * @return \StructType\WebResult
     */
    public function setCacheUrl($cacheUrl = null)
    {
        // validation for constraint: string
        if (!is_null($cacheUrl) && !is_string($cacheUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cacheUrl, true), gettype($cacheUrl)), __LINE__);
        }
        $this->CacheUrl = $cacheUrl;
        return $this;
    }
    /**
     * Get DisplayUrl value
     * @return string|null
     */
    public function getDisplayUrl()
    {
        return $this->DisplayUrl;
    }
    /**
     * Set DisplayUrl value
     * @param string $displayUrl
     * @return \StructType\WebResult
     */
    public function setDisplayUrl($displayUrl = null)
    {
        // validation for constraint: string
        if (!is_null($displayUrl) && !is_string($displayUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayUrl, true), gettype($displayUrl)), __LINE__);
        }
        $this->DisplayUrl = $displayUrl;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\WebResult
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get SearchTags value
     * @return \ArrayType\ArrayOfWebSearchTag|null
     */
    public function getSearchTags()
    {
        return $this->SearchTags;
    }
    /**
     * Set SearchTags value
     * @param \ArrayType\ArrayOfWebSearchTag $searchTags
     * @return \StructType\WebResult
     */
    public function setSearchTags(\ArrayType\ArrayOfWebSearchTag $searchTags = null)
    {
        $this->SearchTags = $searchTags;
        return $this;
    }
    /**
     * Get DeepLinks value
     * @return \ArrayType\ArrayOfDeepLink|null
     */
    public function getDeepLinks()
    {
        return $this->DeepLinks;
    }
    /**
     * Set DeepLinks value
     * @param \ArrayType\ArrayOfDeepLink $deepLinks
     * @return \StructType\WebResult
     */
    public function setDeepLinks(\ArrayType\ArrayOfDeepLink $deepLinks = null)
    {
        $this->DeepLinks = $deepLinks;
        return $this;
    }
}
