<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoResult StructType
 * @subpackage Structs
 */
class VideoResult extends AbstractStructBase
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The PlayUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlayUrl;
    /**
     * The SourceTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceTitle;
    /**
     * The RunTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $RunTime;
    /**
     * The ClickThroughPageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClickThroughPageUrl;
    /**
     * The StaticThumbnail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Thumbnail
     */
    public $StaticThumbnail;
    /**
     * Constructor method for VideoResult
     * @uses VideoResult::setTitle()
     * @uses VideoResult::setPlayUrl()
     * @uses VideoResult::setSourceTitle()
     * @uses VideoResult::setRunTime()
     * @uses VideoResult::setClickThroughPageUrl()
     * @uses VideoResult::setStaticThumbnail()
     * @param string $title
     * @param string $playUrl
     * @param string $sourceTitle
     * @param int $runTime
     * @param string $clickThroughPageUrl
     * @param \StructType\Thumbnail $staticThumbnail
     */
    public function __construct($title = null, $playUrl = null, $sourceTitle = null, $runTime = null, $clickThroughPageUrl = null, \StructType\Thumbnail $staticThumbnail = null)
    {
        $this
            ->setTitle($title)
            ->setPlayUrl($playUrl)
            ->setSourceTitle($sourceTitle)
            ->setRunTime($runTime)
            ->setClickThroughPageUrl($clickThroughPageUrl)
            ->setStaticThumbnail($staticThumbnail);
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\VideoResult
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get PlayUrl value
     * @return string|null
     */
    public function getPlayUrl()
    {
        return $this->PlayUrl;
    }
    /**
     * Set PlayUrl value
     * @param string $playUrl
     * @return \StructType\VideoResult
     */
    public function setPlayUrl($playUrl = null)
    {
        // validation for constraint: string
        if (!is_null($playUrl) && !is_string($playUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($playUrl, true), gettype($playUrl)), __LINE__);
        }
        $this->PlayUrl = $playUrl;
        return $this;
    }
    /**
     * Get SourceTitle value
     * @return string|null
     */
    public function getSourceTitle()
    {
        return $this->SourceTitle;
    }
    /**
     * Set SourceTitle value
     * @param string $sourceTitle
     * @return \StructType\VideoResult
     */
    public function setSourceTitle($sourceTitle = null)
    {
        // validation for constraint: string
        if (!is_null($sourceTitle) && !is_string($sourceTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceTitle, true), gettype($sourceTitle)), __LINE__);
        }
        $this->SourceTitle = $sourceTitle;
        return $this;
    }
    /**
     * Get RunTime value
     * @return int|null
     */
    public function getRunTime()
    {
        return $this->RunTime;
    }
    /**
     * Set RunTime value
     * @param int $runTime
     * @return \StructType\VideoResult
     */
    public function setRunTime($runTime = null)
    {
        // validation for constraint: int
        if (!is_null($runTime) && !(is_int($runTime) || ctype_digit($runTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($runTime, true), gettype($runTime)), __LINE__);
        }
        $this->RunTime = $runTime;
        return $this;
    }
    /**
     * Get ClickThroughPageUrl value
     * @return string|null
     */
    public function getClickThroughPageUrl()
    {
        return $this->ClickThroughPageUrl;
    }
    /**
     * Set ClickThroughPageUrl value
     * @param string $clickThroughPageUrl
     * @return \StructType\VideoResult
     */
    public function setClickThroughPageUrl($clickThroughPageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($clickThroughPageUrl) && !is_string($clickThroughPageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clickThroughPageUrl, true), gettype($clickThroughPageUrl)), __LINE__);
        }
        $this->ClickThroughPageUrl = $clickThroughPageUrl;
        return $this;
    }
    /**
     * Get StaticThumbnail value
     * @return \StructType\Thumbnail|null
     */
    public function getStaticThumbnail()
    {
        return $this->StaticThumbnail;
    }
    /**
     * Set StaticThumbnail value
     * @param \StructType\Thumbnail $staticThumbnail
     * @return \StructType\VideoResult
     */
    public function setStaticThumbnail(\StructType\Thumbnail $staticThumbnail = null)
    {
        $this->StaticThumbnail = $staticThumbnail;
        return $this;
    }
}
