<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstantAnswerResult StructType
 * @subpackage Structs
 */
class InstantAnswerResult extends AbstractStructBase
{
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The ClickThroughUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClickThroughUrl;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The Attribution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Attribution;
    /**
     * The InstantAnswerSpecificData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstantAnswerSpecificData;
    /**
     * Constructor method for InstantAnswerResult
     * @uses InstantAnswerResult::setContentType()
     * @uses InstantAnswerResult::setTitle()
     * @uses InstantAnswerResult::setClickThroughUrl()
     * @uses InstantAnswerResult::setUrl()
     * @uses InstantAnswerResult::setAttribution()
     * @uses InstantAnswerResult::setInstantAnswerSpecificData()
     * @param string $contentType
     * @param string $title
     * @param string $clickThroughUrl
     * @param string $url
     * @param string $attribution
     * @param string $instantAnswerSpecificData
     */
    public function __construct($contentType = null, $title = null, $clickThroughUrl = null, $url = null, $attribution = null, $instantAnswerSpecificData = null)
    {
        $this
            ->setContentType($contentType)
            ->setTitle($title)
            ->setClickThroughUrl($clickThroughUrl)
            ->setUrl($url)
            ->setAttribution($attribution)
            ->setInstantAnswerSpecificData($instantAnswerSpecificData);
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\InstantAnswerResult
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\InstantAnswerResult
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get ClickThroughUrl value
     * @return string|null
     */
    public function getClickThroughUrl()
    {
        return $this->ClickThroughUrl;
    }
    /**
     * Set ClickThroughUrl value
     * @param string $clickThroughUrl
     * @return \StructType\InstantAnswerResult
     */
    public function setClickThroughUrl($clickThroughUrl = null)
    {
        // validation for constraint: string
        if (!is_null($clickThroughUrl) && !is_string($clickThroughUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clickThroughUrl, true), gettype($clickThroughUrl)), __LINE__);
        }
        $this->ClickThroughUrl = $clickThroughUrl;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\InstantAnswerResult
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get Attribution value
     * @return string|null
     */
    public function getAttribution()
    {
        return $this->Attribution;
    }
    /**
     * Set Attribution value
     * @param string $attribution
     * @return \StructType\InstantAnswerResult
     */
    public function setAttribution($attribution = null)
    {
        // validation for constraint: string
        if (!is_null($attribution) && !is_string($attribution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attribution, true), gettype($attribution)), __LINE__);
        }
        $this->Attribution = $attribution;
        return $this;
    }
    /**
     * Get InstantAnswerSpecificData value
     * @return string|null
     */
    public function getInstantAnswerSpecificData()
    {
        return $this->InstantAnswerSpecificData;
    }
    /**
     * Set InstantAnswerSpecificData value
     * @param string $instantAnswerSpecificData
     * @return \StructType\InstantAnswerResult
     */
    public function setInstantAnswerSpecificData($instantAnswerSpecificData = null)
    {
        // validation for constraint: string
        if (!is_null($instantAnswerSpecificData) && !is_string($instantAnswerSpecificData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instantAnswerSpecificData, true), gettype($instantAnswerSpecificData)), __LINE__);
        }
        $this->InstantAnswerSpecificData = $instantAnswerSpecificData;
        return $this;
    }
}
