<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Parameter;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The HelpUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HelpUrl;
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceType;
    /**
     * The SourceTypeErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SourceTypeErrorCode;
    /**
     * Constructor method for Error
     * @uses Error::setCode()
     * @uses Error::setMessage()
     * @uses Error::setParameter()
     * @uses Error::setValue()
     * @uses Error::setHelpUrl()
     * @uses Error::setSourceType()
     * @uses Error::setSourceTypeErrorCode()
     * @param int $code
     * @param string $message
     * @param string $parameter
     * @param string $value
     * @param string $helpUrl
     * @param string $sourceType
     * @param int $sourceTypeErrorCode
     */
    public function __construct($code = null, $message = null, $parameter = null, $value = null, $helpUrl = null, $sourceType = null, $sourceTypeErrorCode = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setParameter($parameter)
            ->setValue($value)
            ->setHelpUrl($helpUrl)
            ->setSourceType($sourceType)
            ->setSourceTypeErrorCode($sourceTypeErrorCode);
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\Error
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\Error
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->Parameter;
    }
    /**
     * Set Parameter value
     * @param string $parameter
     * @return \StructType\Error
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: string
        if (!is_null($parameter) && !is_string($parameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameter, true), gettype($parameter)), __LINE__);
        }
        $this->Parameter = $parameter;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\Error
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get HelpUrl value
     * @return string|null
     */
    public function getHelpUrl()
    {
        return $this->HelpUrl;
    }
    /**
     * Set HelpUrl value
     * @param string $helpUrl
     * @return \StructType\Error
     */
    public function setHelpUrl($helpUrl = null)
    {
        // validation for constraint: string
        if (!is_null($helpUrl) && !is_string($helpUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($helpUrl, true), gettype($helpUrl)), __LINE__);
        }
        $this->HelpUrl = $helpUrl;
        return $this;
    }
    /**
     * Get SourceType value
     * @return string|null
     */
    public function getSourceType()
    {
        return $this->SourceType;
    }
    /**
     * Set SourceType value
     * @param string $sourceType
     * @return \StructType\Error
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: string
        if (!is_null($sourceType) && !is_string($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceType, true), gettype($sourceType)), __LINE__);
        }
        $this->SourceType = $sourceType;
        return $this;
    }
    /**
     * Get SourceTypeErrorCode value
     * @return int|null
     */
    public function getSourceTypeErrorCode()
    {
        return $this->SourceTypeErrorCode;
    }
    /**
     * Set SourceTypeErrorCode value
     * @param int $sourceTypeErrorCode
     * @return \StructType\Error
     */
    public function setSourceTypeErrorCode($sourceTypeErrorCode = null)
    {
        // validation for constraint: int
        if (!is_null($sourceTypeErrorCode) && !(is_int($sourceTypeErrorCode) || ctype_digit($sourceTypeErrorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceTypeErrorCode, true), gettype($sourceTypeErrorCode)), __LINE__);
        }
        $this->SourceTypeErrorCode = $sourceTypeErrorCode;
        return $this;
    }
}
