<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVideoResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfVideoResult extends AbstractStructArrayBase
{
    /**
     * The VideoResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VideoResult[]
     */
    public $VideoResult;
    /**
     * Constructor method for ArrayOfVideoResult
     * @uses ArrayOfVideoResult::setVideoResult()
     * @param \StructType\VideoResult[] $videoResult
     */
    public function __construct(array $videoResult = array())
    {
        $this
            ->setVideoResult($videoResult);
    }
    /**
     * Get VideoResult value
     * @return \StructType\VideoResult[]|null
     */
    public function getVideoResult()
    {
        return $this->VideoResult;
    }
    /**
     * This method is responsible for validating the values passed to the setVideoResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideoResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVideoResultForArrayConstraintsFromSetVideoResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfVideoResultVideoResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfVideoResultVideoResultItem instanceof \StructType\VideoResult) {
                $invalidValues[] = is_object($arrayOfVideoResultVideoResultItem) ? get_class($arrayOfVideoResultVideoResultItem) : sprintf('%s(%s)', gettype($arrayOfVideoResultVideoResultItem), var_export($arrayOfVideoResultVideoResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VideoResult property can only contain items of type \StructType\VideoResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VideoResult value
     * @throws \InvalidArgumentException
     * @param \StructType\VideoResult[] $videoResult
     * @return \ArrayType\ArrayOfVideoResult
     */
    public function setVideoResult(array $videoResult = array())
    {
        // validation for constraint: array
        if ('' !== ($videoResultArrayErrorMessage = self::validateVideoResultForArrayConstraintsFromSetVideoResult($videoResult))) {
            throw new \InvalidArgumentException($videoResultArrayErrorMessage, __LINE__);
        }
        $this->VideoResult = $videoResult;
        return $this;
    }
    /**
     * Add item to VideoResult value
     * @throws \InvalidArgumentException
     * @param \StructType\VideoResult $item
     * @return \ArrayType\ArrayOfVideoResult
     */
    public function addToVideoResult(\StructType\VideoResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VideoResult) {
            throw new \InvalidArgumentException(sprintf('The VideoResult property can only contain items of type \StructType\VideoResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VideoResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VideoResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VideoResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VideoResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VideoResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VideoResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VideoResult
     */
    public function getAttributeName()
    {
        return 'VideoResult';
    }
}
