<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSourceType ArrayType
 * @subpackage Arrays
 */
class ArrayOfSourceType extends AbstractStructArrayBase
{
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SourceType;
    /**
     * Constructor method for ArrayOfSourceType
     * @uses ArrayOfSourceType::setSourceType()
     * @param string[] $sourceType
     */
    public function __construct(array $sourceType = array())
    {
        $this
            ->setSourceType($sourceType);
    }
    /**
     * Get SourceType value
     * @return string[]|null
     */
    public function getSourceType()
    {
        return $this->SourceType;
    }
    /**
     * This method is responsible for validating the values passed to the setSourceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSourceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSourceTypeForArrayConstraintsFromSetSourceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSourceTypeSourceTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\SourceType::valueIsValid($arrayOfSourceTypeSourceTypeItem)) {
                $invalidValues[] = is_object($arrayOfSourceTypeSourceTypeItem) ? get_class($arrayOfSourceTypeSourceTypeItem) : sprintf('%s(%s)', gettype($arrayOfSourceTypeSourceTypeItem), var_export($arrayOfSourceTypeSourceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SourceType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\SourceType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SourceType value
     * @uses \EnumType\SourceType::valueIsValid()
     * @uses \EnumType\SourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $sourceType
     * @return \ArrayType\ArrayOfSourceType
     */
    public function setSourceType(array $sourceType = array())
    {
        // validation for constraint: array
        if ('' !== ($sourceTypeArrayErrorMessage = self::validateSourceTypeForArrayConstraintsFromSetSourceType($sourceType))) {
            throw new \InvalidArgumentException($sourceTypeArrayErrorMessage, __LINE__);
        }
        $this->SourceType = $sourceType;
        return $this;
    }
    /**
     * Add item to SourceType value
     * @uses \EnumType\SourceType::valueIsValid()
     * @uses \EnumType\SourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfSourceType
     */
    public function addToSourceType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SourceType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SourceType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SourceType::getValidValues())), __LINE__);
        }
        $this->SourceType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\SourceType::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfSourceType
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SourceType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SourceType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SourceType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SourceType
     */
    public function getAttributeName()
    {
        return 'SourceType';
    }
}
