<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchRequest StructType
 * @subpackage Structs
 */
class SearchRequest extends AbstractStructBase
{
    /**
     * The Query
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Query;
    /**
     * The AppId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AppId;
    /**
     * The Sources
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \ArrayType\ArrayOfSourceType
     */
    public $Sources;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SearchRequest
     */
    public $parameters;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - default: 2.2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Version;
    /**
     * The Market
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Market;
    /**
     * The UILanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UILanguage;
    /**
     * The Adult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adult;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Longitude;
    /**
     * The Radius
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Radius;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSearchOption
     */
    public $Options;
    /**
     * The Web
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WebRequest
     */
    public $Web;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImageRequest
     */
    public $Image;
    /**
     * The Phonebook
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PhonebookRequest
     */
    public $Phonebook;
    /**
     * The Video
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VideoRequest
     */
    public $Video;
    /**
     * The News
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NewsRequest
     */
    public $News;
    /**
     * The MobileWeb
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MobileWebRequest
     */
    public $MobileWeb;
    /**
     * The Translation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TranslationRequest
     */
    public $Translation;
    /**
     * Constructor method for SearchRequest
     * @uses SearchRequest::setQuery()
     * @uses SearchRequest::setAppId()
     * @uses SearchRequest::setSources()
     * @uses SearchRequest::setParameters()
     * @uses SearchRequest::setVersion()
     * @uses SearchRequest::setMarket()
     * @uses SearchRequest::setUILanguage()
     * @uses SearchRequest::setAdult()
     * @uses SearchRequest::setLatitude()
     * @uses SearchRequest::setLongitude()
     * @uses SearchRequest::setRadius()
     * @uses SearchRequest::setOptions()
     * @uses SearchRequest::setWeb()
     * @uses SearchRequest::setImage()
     * @uses SearchRequest::setPhonebook()
     * @uses SearchRequest::setVideo()
     * @uses SearchRequest::setNews()
     * @uses SearchRequest::setMobileWeb()
     * @uses SearchRequest::setTranslation()
     * @param string $query
     * @param string $appId
     * @param \ArrayType\ArrayOfSourceType $sources
     * @param \StructType\SearchRequest $parameters
     * @param string $version
     * @param string $market
     * @param string $uILanguage
     * @param string $adult
     * @param float $latitude
     * @param float $longitude
     * @param float $radius
     * @param \ArrayType\ArrayOfSearchOption $options
     * @param \StructType\WebRequest $web
     * @param \StructType\ImageRequest $image
     * @param \StructType\PhonebookRequest $phonebook
     * @param \StructType\VideoRequest $video
     * @param \StructType\NewsRequest $news
     * @param \StructType\MobileWebRequest $mobileWeb
     * @param \StructType\TranslationRequest $translation
     */
    public function __construct($query = null, $appId = null, \ArrayType\ArrayOfSourceType $sources = null, \StructType\SearchRequest $parameters = null, $version = '2.2', $market = null, $uILanguage = null, $adult = null, $latitude = null, $longitude = null, $radius = null, \ArrayType\ArrayOfSearchOption $options = null, \StructType\WebRequest $web = null, \StructType\ImageRequest $image = null, \StructType\PhonebookRequest $phonebook = null, \StructType\VideoRequest $video = null, \StructType\NewsRequest $news = null, \StructType\MobileWebRequest $mobileWeb = null, \StructType\TranslationRequest $translation = null)
    {
        $this
            ->setQuery($query)
            ->setAppId($appId)
            ->setSources($sources)
            ->setParameters($parameters)
            ->setVersion($version)
            ->setMarket($market)
            ->setUILanguage($uILanguage)
            ->setAdult($adult)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setRadius($radius)
            ->setOptions($options)
            ->setWeb($web)
            ->setImage($image)
            ->setPhonebook($phonebook)
            ->setVideo($video)
            ->setNews($news)
            ->setMobileWeb($mobileWeb)
            ->setTranslation($translation);
    }
    /**
     * Get Query value
     * @return string
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @param string $query
     * @return \StructType\SearchRequest
     */
    public function setQuery($query = null)
    {
        // validation for constraint: string
        if (!is_null($query) && !is_string($query)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($query, true), gettype($query)), __LINE__);
        }
        $this->Query = $query;
        return $this;
    }
    /**
     * Get AppId value
     * @return string
     */
    public function getAppId()
    {
        return $this->AppId;
    }
    /**
     * Set AppId value
     * @param string $appId
     * @return \StructType\SearchRequest
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: string
        if (!is_null($appId) && !is_string($appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->AppId = $appId;
        return $this;
    }
    /**
     * Get Sources value
     * @return \ArrayType\ArrayOfSourceType
     */
    public function getSources()
    {
        return $this->Sources;
    }
    /**
     * Set Sources value
     * @param \ArrayType\ArrayOfSourceType $sources
     * @return \StructType\SearchRequest
     */
    public function setSources(\ArrayType\ArrayOfSourceType $sources = null)
    {
        $this->Sources = $sources;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\SearchRequest
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\SearchRequest $parameters
     * @return \StructType\SearchRequest
     */
    public function setParameters(\StructType\SearchRequest $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\SearchRequest
     */
    public function setVersion($version = '2.2')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Market value
     * @return string|null
     */
    public function getMarket()
    {
        return $this->Market;
    }
    /**
     * Set Market value
     * @param string $market
     * @return \StructType\SearchRequest
     */
    public function setMarket($market = null)
    {
        // validation for constraint: string
        if (!is_null($market) && !is_string($market)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($market, true), gettype($market)), __LINE__);
        }
        $this->Market = $market;
        return $this;
    }
    /**
     * Get UILanguage value
     * @return string|null
     */
    public function getUILanguage()
    {
        return $this->UILanguage;
    }
    /**
     * Set UILanguage value
     * @param string $uILanguage
     * @return \StructType\SearchRequest
     */
    public function setUILanguage($uILanguage = null)
    {
        // validation for constraint: string
        if (!is_null($uILanguage) && !is_string($uILanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uILanguage, true), gettype($uILanguage)), __LINE__);
        }
        $this->UILanguage = $uILanguage;
        return $this;
    }
    /**
     * Get Adult value
     * @return string|null
     */
    public function getAdult()
    {
        return $this->Adult;
    }
    /**
     * Set Adult value
     * @uses \EnumType\AdultOption::valueIsValid()
     * @uses \EnumType\AdultOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $adult
     * @return \StructType\SearchRequest
     */
    public function setAdult($adult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdultOption::valueIsValid($adult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdultOption', is_array($adult) ? implode(', ', $adult) : var_export($adult, true), implode(', ', \EnumType\AdultOption::getValidValues())), __LINE__);
        }
        $this->Adult = $adult;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\SearchRequest
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\SearchRequest
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Radius value
     * @return float|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param float $radius
     * @return \StructType\SearchRequest
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: float
        if (!is_null($radius) && !(is_float($radius) || is_numeric($radius))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($radius, true), gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfSearchOption|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfSearchOption $options
     * @return \StructType\SearchRequest
     */
    public function setOptions(\ArrayType\ArrayOfSearchOption $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get Web value
     * @return \StructType\WebRequest|null
     */
    public function getWeb()
    {
        return $this->Web;
    }
    /**
     * Set Web value
     * @param \StructType\WebRequest $web
     * @return \StructType\SearchRequest
     */
    public function setWeb(\StructType\WebRequest $web = null)
    {
        $this->Web = $web;
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\ImageRequest|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \StructType\ImageRequest $image
     * @return \StructType\SearchRequest
     */
    public function setImage(\StructType\ImageRequest $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get Phonebook value
     * @return \StructType\PhonebookRequest|null
     */
    public function getPhonebook()
    {
        return $this->Phonebook;
    }
    /**
     * Set Phonebook value
     * @param \StructType\PhonebookRequest $phonebook
     * @return \StructType\SearchRequest
     */
    public function setPhonebook(\StructType\PhonebookRequest $phonebook = null)
    {
        $this->Phonebook = $phonebook;
        return $this;
    }
    /**
     * Get Video value
     * @return \StructType\VideoRequest|null
     */
    public function getVideo()
    {
        return $this->Video;
    }
    /**
     * Set Video value
     * @param \StructType\VideoRequest $video
     * @return \StructType\SearchRequest
     */
    public function setVideo(\StructType\VideoRequest $video = null)
    {
        $this->Video = $video;
        return $this;
    }
    /**
     * Get News value
     * @return \StructType\NewsRequest|null
     */
    public function getNews()
    {
        return $this->News;
    }
    /**
     * Set News value
     * @param \StructType\NewsRequest $news
     * @return \StructType\SearchRequest
     */
    public function setNews(\StructType\NewsRequest $news = null)
    {
        $this->News = $news;
        return $this;
    }
    /**
     * Get MobileWeb value
     * @return \StructType\MobileWebRequest|null
     */
    public function getMobileWeb()
    {
        return $this->MobileWeb;
    }
    /**
     * Set MobileWeb value
     * @param \StructType\MobileWebRequest $mobileWeb
     * @return \StructType\SearchRequest
     */
    public function setMobileWeb(\StructType\MobileWebRequest $mobileWeb = null)
    {
        $this->MobileWeb = $mobileWeb;
        return $this;
    }
    /**
     * Get Translation value
     * @return \StructType\TranslationRequest|null
     */
    public function getTranslation()
    {
        return $this->Translation;
    }
    /**
     * Set Translation value
     * @param \StructType\TranslationRequest $translation
     * @return \StructType\SearchRequest
     */
    public function setTranslation(\StructType\TranslationRequest $translation = null)
    {
        $this->Translation = $translation;
        return $this;
    }
}
