<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhonebookRequest StructType
 * @subpackage Structs
 */
class PhonebookRequest extends AbstractStructBase
{
    /**
     * The Offset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Offset;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The FileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileType;
    /**
     * The SortBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortBy;
    /**
     * The LocId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocId;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * Constructor method for PhonebookRequest
     * @uses PhonebookRequest::setOffset()
     * @uses PhonebookRequest::setCount()
     * @uses PhonebookRequest::setFileType()
     * @uses PhonebookRequest::setSortBy()
     * @uses PhonebookRequest::setLocId()
     * @uses PhonebookRequest::setCategory()
     * @param int $offset
     * @param int $count
     * @param string $fileType
     * @param string $sortBy
     * @param string $locId
     * @param string $category
     */
    public function __construct($offset = null, $count = null, $fileType = null, $sortBy = null, $locId = null, $category = null)
    {
        $this
            ->setOffset($offset)
            ->setCount($count)
            ->setFileType($fileType)
            ->setSortBy($sortBy)
            ->setLocId($locId)
            ->setCategory($category);
    }
    /**
     * Get Offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param int $offset
     * @return \StructType\PhonebookRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\PhonebookRequest
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @param string $fileType
     * @return \StructType\PhonebookRequest
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get SortBy value
     * @return string|null
     */
    public function getSortBy()
    {
        return $this->SortBy;
    }
    /**
     * Set SortBy value
     * @uses \EnumType\PhonebookSortOption::valueIsValid()
     * @uses \EnumType\PhonebookSortOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortBy
     * @return \StructType\PhonebookRequest
     */
    public function setSortBy($sortBy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PhonebookSortOption::valueIsValid($sortBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PhonebookSortOption', is_array($sortBy) ? implode(', ', $sortBy) : var_export($sortBy, true), implode(', ', \EnumType\PhonebookSortOption::getValidValues())), __LINE__);
        }
        $this->SortBy = $sortBy;
        return $this;
    }
    /**
     * Get LocId value
     * @return string|null
     */
    public function getLocId()
    {
        return $this->LocId;
    }
    /**
     * Set LocId value
     * @param string $locId
     * @return \StructType\PhonebookRequest
     */
    public function setLocId($locId = null)
    {
        // validation for constraint: string
        if (!is_null($locId) && !is_string($locId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locId, true), gettype($locId)), __LINE__);
        }
        $this->LocId = $locId;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\PhonebookRequest
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
}
