<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNewsCollection ArrayType
 * @subpackage Arrays
 */
class ArrayOfNewsCollection extends AbstractStructArrayBase
{
    /**
     * The NewsCollection
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NewsCollection[]
     */
    public $NewsCollection;
    /**
     * Constructor method for ArrayOfNewsCollection
     * @uses ArrayOfNewsCollection::setNewsCollection()
     * @param \StructType\NewsCollection[] $newsCollection
     */
    public function __construct(array $newsCollection = array())
    {
        $this
            ->setNewsCollection($newsCollection);
    }
    /**
     * Get NewsCollection value
     * @return \StructType\NewsCollection[]|null
     */
    public function getNewsCollection()
    {
        return $this->NewsCollection;
    }
    /**
     * This method is responsible for validating the values passed to the setNewsCollection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNewsCollection method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNewsCollectionForArrayConstraintsFromSetNewsCollection(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNewsCollectionNewsCollectionItem) {
            // validation for constraint: itemType
            if (!$arrayOfNewsCollectionNewsCollectionItem instanceof \StructType\NewsCollection) {
                $invalidValues[] = is_object($arrayOfNewsCollectionNewsCollectionItem) ? get_class($arrayOfNewsCollectionNewsCollectionItem) : sprintf('%s(%s)', gettype($arrayOfNewsCollectionNewsCollectionItem), var_export($arrayOfNewsCollectionNewsCollectionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NewsCollection property can only contain items of type \StructType\NewsCollection, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NewsCollection value
     * @throws \InvalidArgumentException
     * @param \StructType\NewsCollection[] $newsCollection
     * @return \ArrayType\ArrayOfNewsCollection
     */
    public function setNewsCollection(array $newsCollection = array())
    {
        // validation for constraint: array
        if ('' !== ($newsCollectionArrayErrorMessage = self::validateNewsCollectionForArrayConstraintsFromSetNewsCollection($newsCollection))) {
            throw new \InvalidArgumentException($newsCollectionArrayErrorMessage, __LINE__);
        }
        $this->NewsCollection = $newsCollection;
        return $this;
    }
    /**
     * Add item to NewsCollection value
     * @throws \InvalidArgumentException
     * @param \StructType\NewsCollection $item
     * @return \ArrayType\ArrayOfNewsCollection
     */
    public function addToNewsCollection(\StructType\NewsCollection $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NewsCollection) {
            throw new \InvalidArgumentException(sprintf('The NewsCollection property can only contain items of type \StructType\NewsCollection, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NewsCollection[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NewsCollection|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NewsCollection|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NewsCollection|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NewsCollection|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NewsCollection|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NewsCollection
     */
    public function getAttributeName()
    {
        return 'NewsCollection';
    }
}
